/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.servlet.impl.event.request;

import java.net.URL;
import javax.inject.Inject;
import org.apache.deltaspike.test.category.WebProfileCategory;
import org.apache.deltaspike.test.servlet.impl.event.request.RequestResponseEventsObserver;
import org.apache.deltaspike.test.servlet.impl.util.ArchiveUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={WebProfileCategory.class})
public class RequestResponseEventsTest {
    @Inject
    private RequestResponseEventsObserver observer;

    @Deployment
    public static WebArchive getDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(RequestResponseEventsTest.class.getSimpleName() + ".war"))).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndServletModuleArchive())).addClass(RequestResponseEventsObserver.class)).addAsWebInfResource((Asset)new StringAsset("<beans/>"), "beans.xml")).addAsWebResource((Asset)new StringAsset("foobar"), "foobar.txt");
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void sendRequest(@ArquillianResource URL contextPath) throws Exception {
        String url = new URL(contextPath, "foobar.txt").toString();
        HttpResponse response = new DefaultHttpClient().execute((HttpUriRequest)new HttpGet(url));
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    @InSequence(value=3)
    public void shouldReceiveRequestInitializedEvent() {
        Assert.assertTrue((String)"Didn't receive expected event", (boolean)this.observer.getEventLog().contains("Initialized HttpServletRequest: /RequestResponseEventsTest/foobar.txt"));
    }

    @Test
    @InSequence(value=3)
    public void shouldReceiveResponseInitializedEvent() {
        Assert.assertTrue((String)"Didn't receive expected event", (boolean)this.observer.getEventLog().contains("Initialized HttpServletResponse"));
    }

    @Test
    @InSequence(value=3)
    public void shouldReceiveRequestDestroyedEvent() {
        Assert.assertTrue((String)"Didn't receive expected event", (boolean)this.observer.getEventLog().contains("Destroyed HttpServletRequest: /RequestResponseEventsTest/foobar.txt"));
    }

    @Test
    @InSequence(value=3)
    public void shouldReceiveResponseDestroyedEvent() {
        Assert.assertTrue((String)"Didn't receive expected event", (boolean)this.observer.getEventLog().contains("Destroyed HttpServletResponse"));
    }
}

