/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.servlet.impl.event.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.deltaspike.core.api.common.DeltaSpike;
import org.apache.deltaspike.core.api.lifecycle.Destroyed;
import org.apache.deltaspike.core.api.lifecycle.Initialized;

@ApplicationScoped
public class ServletContextEventsObserver {
    private final List<String> eventLog = new ArrayList<String>();
    @Inject
    @DeltaSpike
    private ServletContext servletContext;

    public void contextInitialized(@Observes @Initialized ServletContext context) {
        this.eventLog.add("Initialized ServletContext: " + context.getServletContextName());
        if (this.servletContext != null) {
            this.eventLog.add("ServletContext was injected");
        }
    }

    public void contextDestroyed(@Observes @Destroyed ServletContext context) {
        this.eventLog.add("Destroyed ServletContext: " + context.getServletContextName());
    }

    public int getEventCount() {
        return this.eventLog.size();
    }

    public List<String> getEventLog() {
        return Collections.unmodifiableList(this.eventLog);
    }
}

