/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.servlet.impl.event.session;

import java.net.URL;
import javax.inject.Inject;
import org.apache.deltaspike.test.category.WebProfileCategory;
import org.apache.deltaspike.test.servlet.impl.event.session.CreateSessionServlet;
import org.apache.deltaspike.test.servlet.impl.event.session.DestroySessionServlet;
import org.apache.deltaspike.test.servlet.impl.event.session.SessionEventsObserver;
import org.apache.deltaspike.test.servlet.impl.util.ArchiveUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={WebProfileCategory.class})
public class SessionEventsTest {
    private static DefaultHttpClient client;
    @Inject
    private SessionEventsObserver observer;

    @Deployment
    public static WebArchive getDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(SessionEventsTest.class.getSimpleName() + ".war"))).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndServletModuleArchive())).addClass(SessionEventsObserver.class)).addClass(CreateSessionServlet.class)).addClass(DestroySessionServlet.class)).addAsWebInfResource((Asset)new StringAsset("<beans/>"), "beans.xml")).addAsWebResource((Asset)new StringAsset("foobar"), "foobar.txt")).setWebXML((Asset)new StringAsset(((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).servlet(CreateSessionServlet.class, new String[]{"/create-session"}).servlet(DestroySessionServlet.class, new String[]{"/destroy-session"}).exportAsString()));
    }

    @BeforeClass
    public static void initHttpClient() {
        client = new DefaultHttpClient();
        client.getParams().setParameter("http.protocol.cookie-policy", (Object)"rfc2109");
    }

    @AfterClass
    public static void destroyHttpClient() {
        client = null;
    }

    @Test
    @RunAsClient
    @InSequence(value=1)
    public void sendStatelessRequest(@ArquillianResource URL contextPath) throws Exception {
        String url = new URL(contextPath, "foobar.txt").toString();
        HttpResponse response = client.execute((HttpUriRequest)new HttpGet(url));
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
    }

    @Test
    @InSequence(value=2)
    public void statelessRequestDoesntEmitEvents() {
        Assert.assertEquals((long)0L, (long)this.observer.getEventCount());
    }

    @Test
    @RunAsClient
    @InSequence(value=3)
    public void sendRequestToCreateSession(@ArquillianResource URL contextPath) throws Exception {
        String url = new URL(contextPath, "create-session").toString();
        HttpResponse response = client.execute((HttpUriRequest)new HttpGet(url));
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
    }

    @Test
    @InSequence(value=4)
    public void shouldReceiveInitializedSessionEvent() {
        Assert.assertEquals((long)1L, (long)this.observer.getEventCount());
        Assert.assertTrue((String)"Didn't receive expected event", (boolean)this.observer.getEventLog().contains("Initialized HttpSession"));
    }

    @Test
    @RunAsClient
    @InSequence(value=5)
    public void sendRequestToDestroySession(@ArquillianResource URL contextPath) throws Exception {
        String url = new URL(contextPath, "destroy-session").toString();
        HttpResponse response = client.execute((HttpUriRequest)new HttpGet(url));
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
    }

    @Test
    @InSequence(value=6)
    public void shouldReceiveDestroyedSessionEvent() {
        Assert.assertEquals((long)2L, (long)this.observer.getEventCount());
        Assert.assertTrue((String)"Didn't receive expected event", (boolean)this.observer.getEventLog().contains("Destroyed HttpSession"));
    }
}

