/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.servlet.impl.event.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.deltaspike.core.api.lifecycle.Destroyed;
import org.apache.deltaspike.core.api.lifecycle.Initialized;

@ApplicationScoped
public class RequestResponseEventsObserver {
    private final List<String> eventLog = new ArrayList<String>();

    public void requestInitialized(@Observes @Initialized HttpServletRequest request) {
        this.eventLog.add("Initialized HttpServletRequest: " + request.getRequestURI());
    }

    public void responseInitialized(@Observes @Initialized HttpServletResponse response) {
        this.eventLog.add("Initialized HttpServletResponse");
    }

    public void requestDestroyed(@Observes @Destroyed HttpServletRequest request) {
        this.eventLog.add("Destroyed HttpServletRequest: " + request.getRequestURI());
    }

    public void responseDestroyed(@Observes @Destroyed HttpServletResponse response) {
        this.eventLog.add("Destroyed HttpServletResponse");
    }

    public int getEventCount() {
        return this.eventLog.size();
    }

    public List<String> getEventLog() {
        return Collections.unmodifiableList(this.eventLog);
    }
}

