/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.servlet.impl.produce;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

class RequestResponseHolder<Type> {
    static final RequestResponseHolder<ServletRequest> REQUEST = new RequestResponseHolder();
    static final RequestResponseHolder<ServletResponse> RESPONSE = new RequestResponseHolder();
    private final ThreadLocal<Type> threadLocal = new ThreadLocal();

    private RequestResponseHolder() {
    }

    void bind(Type instance) {
        if (this.isBound()) {
            throw new IllegalStateException("There is already an instance bound to this thread.");
        }
        this.threadLocal.set(instance);
    }

    boolean isBound() {
        return this.threadLocal.get() != null;
    }

    void release() {
        this.threadLocal.remove();
    }

    Type get() {
        Type instance = this.threadLocal.get();
        if (instance == null) {
            throw new IllegalStateException("Attempt to access the request/response without an active HTTP request");
        }
        return instance;
    }
}

