/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.scheduler.custom;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.test.scheduler.custom.CustomJob;

@Typed
public class TestJobManager {
    private static TestJobManager currentManager = new TestJobManager();
    private boolean started;
    private List<Class<? extends CustomJob>> registeredJobs = new ArrayList<Class<? extends CustomJob>>();
    private List<Class<? extends CustomJob>> runningJobs = new ArrayList<Class<? extends CustomJob>>();

    public static TestJobManager getInstance() {
        return currentManager;
    }

    @Produces
    @ApplicationScoped
    protected TestJobManager expose() {
        return currentManager;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        currentManager = new TestJobManager();
    }

    public void pauseJob(Class<? extends CustomJob> jobClass) {
        this.registeredJobs.remove(jobClass);
    }

    public void resumeJob(Class<? extends CustomJob> jobClass) {
        this.registeredJobs.add(jobClass);
    }

    public void interruptJob(Class<? extends CustomJob> jobClass) {
        this.runningJobs.remove(jobClass);
    }

    public boolean isExecutingJob(Class<? extends CustomJob> jobClass) {
        return this.runningJobs.contains(jobClass);
    }

    public void registerNewJob(Class<? extends CustomJob> jobClass) {
        this.registeredJobs.add(jobClass);
        this.runningJobs.add(jobClass);
    }

    public void startJobManually(Class<? extends CustomJob> jobClass) {
        this.runningJobs.add(jobClass);
    }

    public boolean isStarted() {
        return this.started;
    }

    public List<Class<? extends CustomJob>> getRegisteredJobs() {
        return this.registeredJobs;
    }

    public List<Class<? extends CustomJob>> getRunningJobs() {
        return this.runningJobs;
    }
}

