/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.scheduler.custom;

import javax.inject.Inject;
import junit.framework.Assert;
import org.apache.deltaspike.scheduler.spi.Scheduler;
import org.apache.deltaspike.test.scheduler.custom.AutoRegisteredJob;
import org.apache.deltaspike.test.scheduler.custom.ManualJob;
import org.apache.deltaspike.test.scheduler.custom.MockedScheduler;
import org.apache.deltaspike.test.scheduler.custom.TestJobManager;
import org.junit.Test;

public abstract class CustomSchedulerTest {
    @Inject
    private Scheduler scheduler;
    @Inject
    private TestJobManager testJobManager;

    @Test
    public void checkAutoRegisteredSchedulerJob() {
        Assert.assertTrue((boolean)this.testJobManager.isStarted());
        Assert.assertEquals((int)1, (int)this.testJobManager.getRegisteredJobs().size());
        Assert.assertEquals(AutoRegisteredJob.class, this.testJobManager.getRegisteredJobs().iterator().next());
        Assert.assertEquals((int)1, (int)this.testJobManager.getRunningJobs().size());
        Assert.assertEquals(AutoRegisteredJob.class, this.testJobManager.getRunningJobs().iterator().next());
    }

    @Test
    public void checkManualSchedulerJobManagement() {
        Assert.assertTrue((boolean)this.testJobManager.isStarted());
        Assert.assertEquals((int)1, (int)this.testJobManager.getRegisteredJobs().size());
        Assert.assertEquals(AutoRegisteredJob.class, this.testJobManager.getRegisteredJobs().iterator().next());
        Assert.assertEquals((int)1, (int)this.testJobManager.getRunningJobs().size());
        Assert.assertEquals(AutoRegisteredJob.class, this.testJobManager.getRunningJobs().iterator().next());
        this.scheduler.registerNewJob(ManualJob.class);
        Assert.assertEquals((int)2, (int)this.testJobManager.getRegisteredJobs().size());
        Assert.assertEquals((int)2, (int)this.testJobManager.getRunningJobs().size());
        this.scheduler.interruptJob(AutoRegisteredJob.class);
        Assert.assertEquals((int)1, (int)this.testJobManager.getRunningJobs().size());
        Assert.assertEquals(ManualJob.class, this.testJobManager.getRunningJobs().iterator().next());
        Assert.assertEquals((int)2, (int)this.testJobManager.getRegisteredJobs().size());
        this.scheduler.pauseJob(AutoRegisteredJob.class);
        Assert.assertEquals((int)1, (int)this.testJobManager.getRegisteredJobs().size());
        Assert.assertEquals(ManualJob.class, this.testJobManager.getRegisteredJobs().iterator().next());
        this.scheduler.pauseJob(ManualJob.class);
        Assert.assertEquals((int)0, (int)this.testJobManager.getRegisteredJobs().size());
        this.scheduler.resumeJob(ManualJob.class);
        Assert.assertEquals((int)1, (int)this.testJobManager.getRegisteredJobs().size());
        Assert.assertEquals(ManualJob.class, this.testJobManager.getRegisteredJobs().iterator().next());
        this.scheduler.pauseJob(ManualJob.class);
        this.scheduler.interruptJob(ManualJob.class);
        Assert.assertEquals((int)0, (int)this.testJobManager.getRunningJobs().size());
        Assert.assertEquals((int)0, (int)this.testJobManager.getRegisteredJobs().size());
        this.scheduler.startJobManually(ManualJob.class);
        Assert.assertTrue((boolean)this.scheduler.isExecutingJob(ManualJob.class));
        Assert.assertEquals((int)0, (int)this.testJobManager.getRegisteredJobs().size());
        this.scheduler.interruptJob(ManualJob.class);
        this.scheduler.registerNewJob(AutoRegisteredJob.class);
        Assert.assertEquals((int)1, (int)this.testJobManager.getRegisteredJobs().size());
    }

    @Test
    public void unwrap() {
        Assert.assertEquals(TestJobManager.class, this.scheduler.unwrap(TestJobManager.class).getClass());
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidUnwrap() {
        this.scheduler.unwrap(MockedScheduler.class);
    }
}

