/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.interceptor.InterceptorBinding;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ServiceUtils;
import org.apache.deltaspike.proxy.spi.ProxyClassGenerator;

public abstract class DeltaSpikeProxyFactory {
    private static final String SUPER_ACCESSOR_METHOD_SUFFIX = "$super";

    private static ProxyClassGenerator lookupService() {
        if (GeneratorHolder.generator == null) {
            List proxyClassGeneratorList = ServiceUtils.loadServiceImplementations(ProxyClassGenerator.class);
            if (proxyClassGeneratorList.size() != 1) {
                throw new IllegalStateException(proxyClassGeneratorList.size() + " implementations of " + ProxyClassGenerator.class.getName() + " found. Expected exactly one implementation.");
            }
            GeneratorHolder.generator = (ProxyClassGenerator)proxyClassGeneratorList.get(0);
        }
        return GeneratorHolder.generator;
    }

    public <T> Class<T> resolveAlreadyDefinedProxyClass(Class<T> targetClass) {
        Class proxyClass = ClassUtils.tryToLoadClassForName((String)this.constructProxyClassName(targetClass), targetClass, (ClassLoader)targetClass.getClassLoader());
        return proxyClass;
    }

    public <T> Class<T> getProxyClass(BeanManager beanManager, Class<T> targetClass) {
        Class<T> proxyClass = this.resolveAlreadyDefinedProxyClass(targetClass);
        if (proxyClass == null) {
            proxyClass = this.createProxyClass(beanManager, targetClass.getClassLoader(), targetClass);
        }
        return proxyClass;
    }

    private synchronized <T> Class<T> createProxyClass(BeanManager beanManager, ClassLoader classLoader, Class<T> targetClass) {
        Class<T> proxyClass = this.resolveAlreadyDefinedProxyClass(targetClass);
        if (proxyClass == null) {
            ArrayList<Method> allMethods = this.collectAllMethods(targetClass);
            ArrayList<Method> interceptMethods = this.filterInterceptMethods(targetClass, allMethods);
            ArrayList<Method> delegateMethods = this.getDelegateMethods(targetClass, allMethods);
            if (interceptMethods != null && !interceptMethods.isEmpty() && !this.containsInterceptorBinding(beanManager, targetClass.getDeclaredAnnotations())) {
                Iterator<Method> iterator = interceptMethods.iterator();
                while (iterator.hasNext()) {
                    Method method = iterator.next();
                    if (this.containsInterceptorBinding(beanManager, method.getDeclaredAnnotations())) continue;
                    iterator.remove();
                }
            }
            ProxyClassGenerator proxyClassGenerator = DeltaSpikeProxyFactory.lookupService();
            proxyClass = proxyClassGenerator.generateProxyClass(classLoader, targetClass, this.getProxyClassSuffix(), SUPER_ACCESSOR_METHOD_SUFFIX, this.getAdditionalInterfacesToImplement(targetClass), delegateMethods == null ? new Method[]{} : delegateMethods.toArray(new Method[delegateMethods.size()]), interceptMethods == null ? new Method[]{} : interceptMethods.toArray(new Method[interceptMethods.size()]));
        }
        return proxyClass;
    }

    protected boolean containsInterceptorBinding(BeanManager beanManager, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            boolean containsInterceptorBinding;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType.isAnnotationPresent(InterceptorBinding.class)) {
                return true;
            }
            if (!beanManager.isStereotype(annotationType) || !(containsInterceptorBinding = this.containsInterceptorBinding(beanManager, annotationType.getDeclaredAnnotations()))) continue;
            return true;
        }
        return false;
    }

    protected String constructProxyClassName(Class<?> clazz) {
        return clazz.getName() + this.getProxyClassSuffix();
    }

    protected static String constructSuperAccessorMethodName(Method method) {
        return method.getName() + SUPER_ACCESSOR_METHOD_SUFFIX;
    }

    public static Method getSuperAccessorMethod(Object proxy, Method method) throws NoSuchMethodException {
        return proxy.getClass().getMethod(DeltaSpikeProxyFactory.constructSuperAccessorMethodName(method), method.getParameterTypes());
    }

    public boolean isProxyClass(Class<?> clazz) {
        return clazz.getName().endsWith(this.getProxyClassSuffix());
    }

    protected boolean hasSameSignature(Method a, Method b) {
        return a.getName().equals(b.getName()) && a.getReturnType().equals(b.getReturnType()) && Arrays.equals(a.getParameterTypes(), b.getParameterTypes());
    }

    protected boolean ignoreMethod(Method method, List<Method> methods) {
        if (method.isBridge()) {
            return true;
        }
        if ("finalize".equals(method.getName())) {
            return true;
        }
        if (methods.contains(method)) {
            return true;
        }
        for (Method currentMethod : methods) {
            if (!this.hasSameSignature(currentMethod, method)) continue;
            return true;
        }
        return false;
    }

    protected ArrayList<Method> collectAllMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (this.ignoreMethod(method, methods)) continue;
            methods.add(method);
        }
        for (Method method : clazz.getMethods()) {
            if (this.ignoreMethod(method, methods)) continue;
            methods.add(method);
        }
        for (Class<?> currentSuperClass = clazz.getSuperclass(); currentSuperClass != null; currentSuperClass = currentSuperClass.getSuperclass()) {
            if (!Modifier.isAbstract(currentSuperClass.getModifiers())) continue;
            for (Method method : currentSuperClass.getDeclaredMethods()) {
                if (this.ignoreMethod(method, methods)) continue;
                methods.add(method);
            }
            for (Method method : currentSuperClass.getMethods()) {
                if (this.ignoreMethod(method, methods)) continue;
                methods.add(method);
            }
        }
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Iterator<Method> methodIterator = methods.iterator();
            while (methodIterator.hasNext()) {
                Method method = methodIterator.next();
                if (!Modifier.isAbstract(method.getModifiers())) continue;
                try {
                    Method foundMethod = currentClass.getMethod(method.getName(), method.getParameterTypes());
                    if (foundMethod == null || Modifier.isAbstract(foundMethod.getModifiers())) continue;
                    methodIterator.remove();
                }
                catch (Exception e) {}
            }
        }
        return methods;
    }

    protected ArrayList<Method> filterInterceptMethods(Class<?> targetClass, ArrayList<Method> allMethods) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : allMethods) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isFinal(method.getModifiers()) || Modifier.isAbstract(method.getModifiers())) continue;
            methods.add(method);
        }
        return methods;
    }

    protected Class<?>[] getAdditionalInterfacesToImplement(Class<?> targetClass) {
        return null;
    }

    protected abstract ArrayList<Method> getDelegateMethods(Class<?> var1, ArrayList<Method> var2);

    protected abstract String getProxyClassSuffix();

    public static class GeneratorHolder {
        private static ProxyClassGenerator generator;

        public void setGenerator(ProxyClassGenerator generator) {
            GeneratorHolder.generator = generator;
        }
    }
}

