/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.util;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.proxy.api.DeltaSpikeProxyFactory;

public class EnableInterceptorsProxyFactory
extends DeltaSpikeProxyFactory {
    private static final EnableInterceptorsProxyFactory INSTANCE = new EnableInterceptorsProxyFactory();

    private EnableInterceptorsProxyFactory() {
    }

    public static <T> T wrap(T obj, BeanManager beanManager) {
        if (obj == null) {
            throw new IllegalArgumentException("obj must not be null!");
        }
        Class<?> proxyClass = INSTANCE.getProxyClass(beanManager, obj.getClass());
        EnableInterceptorsDelegate delegate = new EnableInterceptorsDelegate(obj);
        try {
            Constructor<?> constructor = proxyClass.getConstructor(InvocationHandler.class);
            return (T)constructor.newInstance(delegate);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create proxy instance by class " + obj.getClass(), e);
        }
    }

    @Override
    protected ArrayList<Method> getDelegateMethods(Class<?> targetClass, ArrayList<Method> allMethods) {
        ArrayList<Method> delegateMethods = super.filterInterceptMethods(targetClass, allMethods);
        return delegateMethods;
    }

    @Override
    protected ArrayList<Method> filterInterceptMethods(Class<?> targetClass, ArrayList<Method> allMethods) {
        return null;
    }

    @Override
    protected String getProxyClassSuffix() {
        return "$$DSInterceptorProxy";
    }

    private static class EnableInterceptorsDelegate
    implements InvocationHandler,
    Serializable {
        private final Object instance;

        public EnableInterceptorsDelegate(Object instance) {
            this.instance = instance;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(this.instance, args);
        }
    }
}

