/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.core.api.partialbean.uc003;

import java.lang.annotation.Annotation;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.test.category.SeCategory;
import org.apache.deltaspike.test.core.api.partialbean.shared.CustomInterceptorImpl;
import org.apache.deltaspike.test.core.api.partialbean.shared.TestPartialBeanBinding;
import org.apache.deltaspike.test.core.api.partialbean.uc003.PartialBean;
import org.apache.deltaspike.test.core.api.partialbean.util.ArchiveUtils;
import org.apache.deltaspike.test.utils.CdiContainerUnderTest;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={SeCategory.class})
public class PartialBeanAsAbstractClassWithInterceptorTest {
    public static final String CONTAINER_WELD_2_0_0 = "weld-2\\.0\\.0\\..*";

    @Deployment
    public static WebArchive war() {
        if (CdiContainerUnderTest.is((String[])new String[]{CONTAINER_WELD_2_0_0})) {
            return (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"empty.war");
        }
        StringAsset beansXml = new StringAsset("<beans><interceptors><class>" + CustomInterceptorImpl.class.getName() + "</class></interceptors></beans>");
        String simpleName = PartialBeanAsAbstractClassWithInterceptorTest.class.getSimpleName();
        String archiveName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1);
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(archiveName + ".jar"))).addPackage(PartialBeanAsAbstractClassWithInterceptorTest.class.getPackage())).addPackage(TestPartialBeanBinding.class.getPackage())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(archiveName + ".war"))).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndPartialBeanArchive())).addAsLibraries(new Archive[]{testJar})).addAsWebInfResource((Asset)beansXml, "beans.xml");
    }

    @Test
    public void testPartialBeanAsAbstractClassWithInterceptor() throws Exception {
        Assume.assumeTrue((!CdiContainerUnderTest.is((String[])new String[]{CONTAINER_WELD_2_0_0}) ? 1 : 0) != 0);
        PartialBean partialBean = (PartialBean)BeanProvider.getContextualReference(PartialBean.class, (Annotation[])new Annotation[0]);
        Assert.assertNotNull((Object)partialBean);
        String result = partialBean.getResult();
        Assert.assertEquals((Object)"partial-test-true", (Object)result);
        result = partialBean.getManualResult();
        Assert.assertEquals((Object)"manual-test-false", (Object)result);
    }
}

