/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.security;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.jsf.api.config.JsfModuleConfig;
import org.apache.deltaspike.jsf.api.config.view.View;
import org.apache.deltaspike.jsf.impl.security.AccessDeniedExceptionBroadcaster;
import org.apache.deltaspike.jsf.impl.security.ViewRootAccessHandler;
import org.apache.deltaspike.jsf.impl.util.SecurityUtils;
import org.apache.deltaspike.security.api.authorization.AccessDeniedException;
import org.apache.deltaspike.security.api.authorization.ErrorViewAwareAccessDeniedException;
import org.apache.deltaspike.security.spi.authorization.EditableAccessDecisionVoterContext;

public class SecurityAwareViewHandler
extends ViewHandlerWrapper
implements Deactivatable {
    public static final String PRE_DESTROY_VIEW_MAP_EVENT_FILTER_ENABLED = SecurityAwareViewHandler.class.getName() + "#PRE_DESTROY_VIEW_MAP_EVENT_FILTER_ENABLED";
    protected final ViewHandler wrapped;
    private final boolean activated;
    private Boolean securityModuleActivated;

    public SecurityAwareViewHandler(ViewHandler wrapped) {
        this.wrapped = wrapped;
        this.activated = ClassDeactivationUtils.isActivated(((Object)((Object)this)).getClass());
    }

    public ViewHandler getWrapped() {
        return this.wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot createView(FacesContext context, String viewId) {
        Map originalViewMap;
        UIViewRoot result = this.wrapped.createView(context, viewId);
        if (!this.activated) {
            return result;
        }
        if (this.securityModuleActivated == null) {
            this.lazyInit();
        }
        if (!this.securityModuleActivated.booleanValue()) {
            return result;
        }
        UIViewRoot originalViewRoot = context.getViewRoot();
        HashMap viewMap = null;
        if (originalViewRoot != null && (originalViewMap = originalViewRoot.getViewMap(false)) != null && !originalViewMap.isEmpty()) {
            viewMap = new HashMap();
            viewMap.putAll(originalViewMap);
        }
        this.deactivatePreDestroyViewMapEvent(context);
        context.setViewRoot(result);
        try {
            ViewRootAccessHandler viewRootAccessHandler = (ViewRootAccessHandler)BeanProvider.getContextualReference(ViewRootAccessHandler.class, (Annotation[])new Annotation[0]);
            viewRootAccessHandler.checkAccessTo(result);
        }
        catch (ErrorViewAwareAccessDeniedException accessDeniedException) {
            ViewConfigResolver viewConfigResolver = (ViewConfigResolver)BeanProvider.getContextualReference(ViewConfigResolver.class, (Annotation[])new Annotation[0]);
            ViewConfigDescriptor errorViewDescriptor = viewConfigResolver.getViewConfigDescriptor(accessDeniedException.getErrorView());
            try {
                if (errorViewDescriptor != null && View.NavigationMode.REDIRECT == ((View)errorViewDescriptor.getMetaData(View.class).iterator().next()).navigation() && ((JsfModuleConfig)BeanProvider.getContextualReference(JsfModuleConfig.class, (Annotation[])new Annotation[0])).isAlwaysUseNavigationHandlerOnSecurityViolation()) {
                    SecurityUtils.tryToHandleSecurityViolation((RuntimeException)((Object)accessDeniedException));
                } else {
                    SecurityUtils.handleSecurityViolationWithoutNavigation((RuntimeException)((Object)accessDeniedException));
                }
            }
            finally {
                this.broadcastAccessDeniedException(accessDeniedException);
            }
            if (errorViewDescriptor != null) {
                UIViewRoot uIViewRoot = this.wrapped.createView(context, errorViewDescriptor.getViewId());
                return uIViewRoot;
            }
            if (!context.isPostback() && context.getViewRoot() != null) {
                context.getViewRoot().setViewId(null);
            }
            throw accessDeniedException;
        }
        finally {
            this.activatePreDestroyViewMapEvent(context);
            if (originalViewRoot != null) {
                context.setViewRoot(originalViewRoot);
                if (viewMap != null) {
                    originalViewRoot.getViewMap().putAll(viewMap);
                }
            }
        }
        return result;
    }

    protected void broadcastAccessDeniedException(ErrorViewAwareAccessDeniedException accessDeniedException) {
        AccessDeniedExceptionBroadcaster exceptionBroadcaster = (AccessDeniedExceptionBroadcaster)BeanProvider.getContextualReference(AccessDeniedExceptionBroadcaster.class, (Annotation[])new Annotation[0]);
        Throwable broadcastResult = exceptionBroadcaster.broadcastAccessDeniedException((AccessDeniedException)((Object)accessDeniedException));
        if (broadcastResult != null) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)broadcastResult);
        }
    }

    private synchronized void lazyInit() {
        this.securityModuleActivated = BeanProvider.getContextualReference(EditableAccessDecisionVoterContext.class, (boolean)true, (Annotation[])new Annotation[0]) != null;
        if (!this.securityModuleActivated.booleanValue()) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("security-module-impl isn't used -> " + ((Object)((Object)this)).getClass().getName() + " gets deactivated");
        }
    }

    private void deactivatePreDestroyViewMapEvent(FacesContext facesContext) {
        facesContext.getExternalContext().getRequestMap().put(PRE_DESTROY_VIEW_MAP_EVENT_FILTER_ENABLED, Boolean.TRUE);
    }

    private void activatePreDestroyViewMapEvent(FacesContext facesContext) {
        facesContext.getExternalContext().getRequestMap().put(PRE_DESTROY_VIEW_MAP_EVENT_FILTER_ENABLED, Boolean.FALSE);
    }
}

