/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.scope.window.strategy;

import java.util.Collections;
import java.util.Map;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.deltaspike.core.spi.scope.window.WindowContext;
import org.apache.deltaspike.jsf.api.config.JsfModuleConfig;
import org.apache.deltaspike.jsf.impl.scope.window.strategy.LazyWindowStrategy;
import org.apache.deltaspike.jsf.impl.util.ClientWindowHelper;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindow;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindowConfig;

public abstract class AbstractClientWindowStrategy
implements ClientWindow {
    public static final String DEFAULT_WINDOW_ID = "default";
    private static final String CACHE_QUERY_URL_PARAMETERS = "CACHE:" + AbstractClientWindowStrategy.class.getName() + "#getQueryURLParameters";
    private static final String CACHE_WINDOW_ID = "CACHE:" + AbstractClientWindowStrategy.class.getName() + ".WindowId";
    private static final String PER_USE_CLIENT_WINDOW_URL_QUERY_PARAMETER_DISABLED_KEY = LazyWindowStrategy.class.getName() + ".ClientWindowRenderModeEnablement";
    @Inject
    protected ClientWindowConfig clientWindowConfig;
    @Inject
    protected JsfModuleConfig jsfModuleConfig;
    @Inject
    protected WindowContext windowContext;
    private int maxWindowIdCount = 10;

    @PostConstruct
    protected void init() {
        this.maxWindowIdCount = ClientWindowHelper.getMaxWindowIdLength();
    }

    public String getWindowId(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String windowId = (String)requestMap.get(CACHE_WINDOW_ID);
        if (windowId != null) {
            return windowId;
        }
        windowId = this.getOrCreateWindowId(facesContext);
        if (windowId != null) {
            ClientWindowConfig.ClientWindowRenderMode clientWindowRenderMode = this.clientWindowConfig.getClientWindowRenderMode(facesContext);
            if (!ClientWindowConfig.ClientWindowRenderMode.DELEGATED.equals((Object)clientWindowRenderMode) && windowId.length() > this.maxWindowIdCount) {
                windowId = windowId.substring(0, this.maxWindowIdCount);
            }
            requestMap.put(CACHE_WINDOW_ID, windowId);
        }
        return windowId;
    }

    protected abstract String getOrCreateWindowId(FacesContext var1);

    protected String generateNewWindowId() {
        return "" + new Random().nextInt() % 10000;
    }

    protected boolean isPost(FacesContext facesContext) {
        if (facesContext.isPostback()) {
            return true;
        }
        Object request = facesContext.getExternalContext().getRequest();
        return request instanceof HttpServletRequest && "POST".equals(((HttpServletRequest)request).getMethod());
    }

    protected String getWindowIdPostParameter(FacesContext facesContext) {
        Map requestParams = facesContext.getExternalContext().getRequestParameterMap();
        String windowId = (String)requestParams.get("dspwid");
        if (windowId == null) {
            windowId = (String)requestParams.get("javax.faces.ClientWindow");
        }
        return windowId;
    }

    protected String getWindowIdParameter(FacesContext facesContext) {
        Map requestParameters = facesContext.getExternalContext().getRequestParameterMap();
        return (String)requestParameters.get("dswid");
    }

    public void disableClientWindowRenderMode(FacesContext facesContext) {
        if (this.isSupportClientWindowRenderingMode()) {
            Map attrMap = facesContext.getAttributes();
            attrMap.put(PER_USE_CLIENT_WINDOW_URL_QUERY_PARAMETER_DISABLED_KEY, Boolean.TRUE);
        }
    }

    public void enableClientWindowRenderMode(FacesContext facesContext) {
        if (this.isSupportClientWindowRenderingMode()) {
            Map attrMap = facesContext.getAttributes();
            attrMap.remove(PER_USE_CLIENT_WINDOW_URL_QUERY_PARAMETER_DISABLED_KEY);
        }
    }

    public boolean isClientWindowRenderModeEnabled(FacesContext facesContext) {
        if (this.isSupportClientWindowRenderingMode()) {
            Map attrMap = facesContext.getAttributes();
            return !attrMap.containsKey(PER_USE_CLIENT_WINDOW_URL_QUERY_PARAMETER_DISABLED_KEY);
        }
        return false;
    }

    protected boolean isSupportClientWindowRenderingMode() {
        return false;
    }

    public boolean isInitialRedirectSupported(FacesContext facesContext) {
        return false;
    }

    public Map<String, String> getQueryURLParameters(FacesContext facesContext) {
        Map cachedParameters = (Map)facesContext.getAttributes().get(CACHE_QUERY_URL_PARAMETERS);
        if (cachedParameters == null) {
            cachedParameters = this.createQueryURLParameters(facesContext);
            if (cachedParameters == null) {
                cachedParameters = Collections.EMPTY_MAP;
            }
            facesContext.getAttributes().put(CACHE_QUERY_URL_PARAMETERS, cachedParameters);
        }
        return cachedParameters;
    }

    protected Map<String, String> createQueryURLParameters(FacesContext facesContext) {
        return null;
    }
}

