/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.injection;

import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ApplicationWrapper;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.validator.Validator;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.apache.deltaspike.jsf.api.config.JsfModuleConfig;
import org.apache.deltaspike.jsf.impl.injection.ConverterWrapper;
import org.apache.deltaspike.jsf.impl.injection.ManagedArtifactResolver;
import org.apache.deltaspike.jsf.impl.injection.ValidatorWrapper;
import org.apache.deltaspike.jsf.impl.security.SecurityAwareViewHandler;
import org.apache.deltaspike.proxy.spi.DeltaSpikeProxy;

public class InjectionAwareApplicationWrapper
extends ApplicationWrapper {
    private final Application wrapped;
    private final boolean containerManagedConvertersEnabled;
    private final boolean containerManagedValidatorsEnabled;
    private final boolean preDestroyViewMapEventFilterMode;
    private final boolean fullStateSavingFallbackEnabled;

    public InjectionAwareApplicationWrapper(Application wrapped, JsfModuleConfig jsfModuleConfig, boolean preDestroyViewMapEventFilterMode) {
        this.wrapped = wrapped;
        this.containerManagedConvertersEnabled = jsfModuleConfig.isContainerManagedConvertersEnabled();
        this.containerManagedValidatorsEnabled = jsfModuleConfig.isContainerManagedValidatorsEnabled();
        this.fullStateSavingFallbackEnabled = jsfModuleConfig.isFullStateSavingFallbackEnabled();
        this.preDestroyViewMapEventFilterMode = preDestroyViewMapEventFilterMode;
    }

    public Converter createConverter(Class<?> targetClass) {
        return this.managedOrDefaultConverter(this.wrapped.createConverter(targetClass));
    }

    public Converter createConverter(String converterId) {
        return this.managedOrDefaultConverter(this.wrapped.createConverter(converterId));
    }

    private Converter managedOrDefaultConverter(Converter defaultResult) {
        if (!this.containerManagedConvertersEnabled) {
            return defaultResult;
        }
        if (defaultResult == null) {
            return null;
        }
        Converter result = ManagedArtifactResolver.resolveManagedConverter(defaultResult.getClass());
        if (result == null) {
            return defaultResult;
        }
        if (result instanceof DeltaSpikeProxy || ProxyUtils.isProxiedClass(result.getClass())) {
            return result;
        }
        return new ConverterWrapper(result, this.fullStateSavingFallbackEnabled);
    }

    public Validator createValidator(String validatorId) throws FacesException {
        return this.managedOrDefaultValidator(this.wrapped.createValidator(validatorId));
    }

    private Validator managedOrDefaultValidator(Validator defaultResult) {
        if (!this.containerManagedValidatorsEnabled) {
            return defaultResult;
        }
        if (defaultResult == null) {
            return null;
        }
        Validator result = ManagedArtifactResolver.resolveManagedValidator(defaultResult.getClass());
        if (result == null) {
            return defaultResult;
        }
        if (result instanceof DeltaSpikeProxy || ProxyUtils.isProxiedClass(result.getClass())) {
            return result;
        }
        return new ValidatorWrapper(result, this.fullStateSavingFallbackEnabled);
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Object source) {
        if (!PreDestroyViewMapEvent.class.isAssignableFrom(systemEventClass) || this.isPreDestroyViewMapEventAllowed(facesContext)) {
            super.publishEvent(facesContext, systemEventClass, source);
        }
    }

    private boolean isPreDestroyViewMapEventAllowed(FacesContext facesContext) {
        return !this.preDestroyViewMapEventFilterMode || !Boolean.TRUE.equals(facesContext.getExternalContext().getRequestMap().get(SecurityAwareViewHandler.PRE_DESTROY_VIEW_MAP_EVENT_FILTER_ENABLED));
    }

    public Application getWrapped() {
        return this.wrapped;
    }
}

