/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.config.view;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Stereotype;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.view.ViewConfig;
import org.apache.deltaspike.core.api.config.view.metadata.Aggregated;
import org.apache.deltaspike.core.api.config.view.metadata.ConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.SkipMetaDataMerge;
import org.apache.deltaspike.core.api.config.view.metadata.ViewMetaData;
import org.apache.deltaspike.core.spi.config.view.ConfigNodeConverter;
import org.apache.deltaspike.core.spi.config.view.ConfigPreProcessor;
import org.apache.deltaspike.core.spi.config.view.ViewConfigNode;
import org.apache.deltaspike.core.util.AnnotationUtils;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.core.util.metadata.AnnotationInstanceProvider;
import org.apache.deltaspike.jsf.api.config.view.Folder;
import org.apache.deltaspike.jsf.api.config.view.View;
import org.apache.deltaspike.jsf.impl.config.view.DefaultFolderConfigDescriptor;
import org.apache.deltaspike.jsf.impl.config.view.DefaultViewPathConfigDescriptor;
import org.apache.deltaspike.jsf.impl.util.ViewConfigUtils;

public class DefaultConfigNodeConverter
implements ConfigNodeConverter {
    public ConfigDescriptor convert(ViewConfigNode node) {
        List<Annotation> mergedMetaData = this.mergeMetaData(node.getMetaData(), node.getInheritedMetaData());
        mergedMetaData = this.preProcessMetaData(mergedMetaData, node);
        Class sourceClass = node.getSource();
        if (ViewConfigUtils.isFolderConfig(sourceClass)) {
            Folder folderAnnotation = this.findMetaDataByType(mergedMetaData, Folder.class);
            return new DefaultFolderConfigDescriptor(folderAnnotation.name(), node.getSource(), mergedMetaData, node.getCallbackDescriptors());
        }
        if (ViewConfig.class.isAssignableFrom(sourceClass)) {
            View viewAnnotation = this.findMetaDataByType(mergedMetaData, View.class);
            String viewId = viewAnnotation.basePath() + viewAnnotation.name() + "." + viewAnnotation.extension();
            return new DefaultViewPathConfigDescriptor(viewId, node.getSource(), this.filterInheritedFolderMetaData(mergedMetaData), node.getCallbackDescriptors());
        }
        throw new IllegalStateException(node.getSource() + " isn't a valid view-config");
    }

    private <T> T findMetaDataByType(List<Annotation> metaData, Class<T> target) {
        for (Annotation annotation : metaData) {
            if (!target.equals(annotation.annotationType())) continue;
            return (T)annotation;
        }
        return null;
    }

    private List<Annotation> mergeMetaData(Set<Annotation> metaData, List<Annotation> inheritedMetaData) {
        ArrayList<Annotation> nodeViewMetaData = new ArrayList<Annotation>();
        ArrayList<Annotation> viewMetaDataFromStereotype = new ArrayList<Annotation>();
        for (Annotation annotation : metaData) {
            if (annotation.annotationType().isAnnotationPresent(ViewMetaData.class)) {
                nodeViewMetaData.add(annotation);
            }
            if (!annotation.annotationType().isAnnotationPresent(Stereotype.class)) continue;
            for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                if (!metaAnnotation.annotationType().isAnnotationPresent(ViewMetaData.class)) continue;
                viewMetaDataFromStereotype.add(metaAnnotation);
            }
        }
        List<Annotation> result = this.mergeAnnotationInstances(viewMetaDataFromStereotype, nodeViewMetaData);
        if (inheritedMetaData != null && !inheritedMetaData.isEmpty()) {
            result = this.mergeAnnotationInstances(inheritedMetaData, result);
        }
        return result;
    }

    private List<Annotation> mergeAnnotationInstances(List<Annotation> inheritedMetaData, List<Annotation> nodeMetaData) {
        ArrayList<Annotation> mergedResult = new ArrayList<Annotation>();
        for (Annotation inheritedAnnotation : inheritedMetaData) {
            ViewMetaData viewMetaData = inheritedAnnotation.annotationType().getAnnotation(ViewMetaData.class);
            if (viewMetaData == null) continue;
            Aggregated aggregated = inheritedAnnotation.annotationType().getAnnotation(Aggregated.class);
            if (aggregated == null) {
                aggregated = viewMetaData.annotationType().getAnnotation(Aggregated.class);
            }
            if (aggregated.value()) {
                mergedResult.add(inheritedAnnotation);
                continue;
            }
            Annotation currentNodeMetaData = this.findInResult(nodeMetaData, inheritedAnnotation);
            if (currentNodeMetaData == null) {
                Annotation mergedMetaData = this.findInResult(mergedResult, inheritedAnnotation);
                if (mergedMetaData == null) {
                    mergedResult.add(inheritedAnnotation);
                    continue;
                }
                Annotation mergedAnnotation = this.mergeAnnotationInstance(mergedMetaData, inheritedAnnotation);
                mergedResult.add(mergedAnnotation);
                continue;
            }
            Annotation mergedAnnotation = this.mergeAnnotationInstance(currentNodeMetaData, inheritedAnnotation);
            mergedResult.add(mergedAnnotation);
        }
        mergedResult.addAll(0, nodeMetaData);
        return mergedResult;
    }

    private Annotation mergeAnnotationInstance(Annotation existingMetaData, Annotation inheritedMetaData) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Method annotationMethod : existingMetaData.annotationType().getDeclaredMethods()) {
            annotationMethod.setAccessible(true);
            Annotation defaultAnnotation = AnnotationInstanceProvider.of(existingMetaData.annotationType());
            try {
                Object defaultValue = annotationMethod.invoke((Object)defaultAnnotation, new Object[0]);
                Object existingValue = annotationMethod.invoke((Object)existingMetaData, new Object[0]);
                if (existingValue == null || existingValue.equals(defaultValue)) {
                    Object inheritedValue = annotationMethod.invoke((Object)inheritedMetaData, new Object[0]);
                    if (inheritedValue == null || inheritedValue.equals(defaultValue) || annotationMethod.isAnnotationPresent(SkipMetaDataMerge.class)) {
                        values.put(annotationMethod.getName(), defaultValue);
                        continue;
                    }
                    values.put(annotationMethod.getName(), inheritedValue);
                    continue;
                }
                values.put(annotationMethod.getName(), existingValue);
            }
            catch (Exception e) {
                ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
        return AnnotationInstanceProvider.of(existingMetaData.annotationType(), values);
    }

    private List<Annotation> preProcessMetaData(List<Annotation> mergedMetaData, ViewConfigNode node) {
        ArrayList<Annotation> result = new ArrayList<Annotation>(mergedMetaData.size());
        for (Annotation annotation : mergedMetaData) {
            ViewMetaData viewMetaData = annotation.annotationType().getAnnotation(ViewMetaData.class);
            Class preProcessorClass = viewMetaData.preProcessor();
            if (!ConfigPreProcessor.class.equals((Object)preProcessorClass)) {
                ConfigPreProcessor preProcessor;
                Annotation resultToAdd;
                String customPreProcessorClassName = ConfigResolver.getPropertyValue((String)preProcessorClass.getName(), null);
                if (customPreProcessorClassName != null) {
                    Class customPreProcessorClass = ClassUtils.tryToLoadClassForName((String)customPreProcessorClassName, ConfigPreProcessor.class);
                    if (customPreProcessorClass != null) {
                        preProcessorClass = customPreProcessorClass;
                    } else {
                        throw new IllegalStateException(customPreProcessorClassName + " is configured to replace " + preProcessorClass.getName() + ", but it wasn't possible to load it.");
                    }
                }
                if ((resultToAdd = (preProcessor = (ConfigPreProcessor)ClassUtils.tryToInstantiateClass((Class)preProcessorClass)).beforeAddToConfig(annotation, node)) != annotation) {
                    this.validateAnnotationChange(annotation);
                    this.rewriteMetaDataOfNode(node.getMetaData(), annotation, resultToAdd);
                    this.rewriteMetaDataOfNode(node.getInheritedMetaData(), annotation, resultToAdd);
                }
                result.add(resultToAdd);
                continue;
            }
            result.add(annotation);
        }
        return result;
    }

    private Annotation findInResult(List<Annotation> annotationList, Annotation annotationToFind) {
        for (Annotation annotation : annotationList) {
            if (!annotationToFind.annotationType().equals(annotation.annotationType())) continue;
            annotationList.remove(annotation);
            return annotation;
        }
        return null;
    }

    private List<Annotation> filterInheritedFolderMetaData(List<Annotation> mergedMetaData) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation metaData : mergedMetaData) {
            if (Folder.class.equals(metaData.annotationType())) continue;
            result.add(metaData);
        }
        return result;
    }

    protected void validateAnnotationChange(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (Folder.class.equals(annotationType) || View.class.equals(annotationType)) {
            return;
        }
        ViewMetaData viewMetaData = annotationType.getAnnotation(ViewMetaData.class);
        if (viewMetaData == null) {
            return;
        }
        Aggregated aggregated = viewMetaData.annotationType().getAnnotation(Aggregated.class);
        if (aggregated != null && aggregated.value()) {
            throw new IllegalStateException("it isn't supported to change aggregated meta-data,because inheritance won't work correctly");
        }
    }

    protected void rewriteMetaDataOfNode(Collection<Annotation> metaData, Annotation oldMetaData, Annotation newMetaData) {
        Iterator<Annotation> metaDataIterator = metaData.iterator();
        while (metaDataIterator.hasNext()) {
            Annotation currentMetaData = metaDataIterator.next();
            if (AnnotationUtils.getQualifierHashCode((Annotation)currentMetaData) != AnnotationUtils.getQualifierHashCode((Annotation)oldMetaData)) continue;
            metaDataIterator.remove();
            metaData.add(newMetaData);
            break;
        }
    }
}

