/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.faces.context.FacesContext;
import org.apache.deltaspike.jsf.util.ValueExpressionEvaluationInputStream;
import org.apache.myfaces.test.base.junit4.AbstractJsfTestCase;
import org.junit.Assert;
import org.junit.Test;

public class ValueExpressionEvaluationInputStreamTest
extends AbstractJsfTestCase {
    @Test
    public void testStreamWithoutExpression_mustBeUnmodified() throws Exception {
        String data = "aa\nbbbb\ncccc\ndddd\n\n";
        byte[] dataArray = "aa\nbbbb\ncccc\ndddd\n\n".getBytes();
        ValueExpressionEvaluationInputStream inputStream = new ValueExpressionEvaluationInputStream(FacesContext.getCurrentInstance(), (InputStream)new ByteArrayInputStream(dataArray));
        byte[] inputStreamDataArray = new byte[dataArray.length];
        inputStream.read(inputStreamDataArray);
        Assert.assertArrayEquals((byte[])dataArray, (byte[])inputStreamDataArray);
        Assert.assertEquals((long)-1L, (long)inputStream.read());
    }

    @Test
    public void testStreamWithSimpleExpression_mustBeEvaluated() throws Exception {
        String data = "aa\nbbbb\ncc#{requestScope.test}cc\ndddd\n\n";
        String evaluatedData = "aa\nbbbb\ncctest-valuecc\ndddd\n\n";
        byte[] dataArray = "aa\nbbbb\ncc#{requestScope.test}cc\ndddd\n\n".getBytes();
        byte[] evaluatedDataArray = "aa\nbbbb\ncctest-valuecc\ndddd\n\n".getBytes();
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put("test", "test-value");
        ValueExpressionEvaluationInputStream inputStream = new ValueExpressionEvaluationInputStream(FacesContext.getCurrentInstance(), (InputStream)new ByteArrayInputStream(dataArray));
        byte[] inputStreamDataArray = new byte[evaluatedDataArray.length];
        inputStream.read(inputStreamDataArray);
        Assert.assertArrayEquals((byte[])evaluatedDataArray, (byte[])inputStreamDataArray);
        Assert.assertEquals((long)-1L, (long)inputStream.read());
    }

    @Test
    public void testStreamWithHalfExpressionAtEnd_mustBeUnmodified() throws Exception {
        String data = "aa\nbbbb\ncccc\ndddd\n\n#{requestScope.test";
        byte[] dataArray = "aa\nbbbb\ncccc\ndddd\n\n#{requestScope.test".getBytes();
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put("test", "test-value");
        ValueExpressionEvaluationInputStream inputStream = new ValueExpressionEvaluationInputStream(FacesContext.getCurrentInstance(), (InputStream)new ByteArrayInputStream(dataArray));
        byte[] inputStreamDataArray = new byte[dataArray.length];
        inputStream.read(inputStreamDataArray);
        Assert.assertArrayEquals((byte[])dataArray, (byte[])inputStreamDataArray);
        Assert.assertEquals((long)-1L, (long)inputStream.read());
    }

    @Test
    public void testStreamWithHalfExpressionAtLineEnd_mustBeUnmodified() throws Exception {
        String data = "aa\nbb#{requestScope.test\n}bb\ncccc\ndddd\n\n";
        byte[] dataArray = "aa\nbb#{requestScope.test\n}bb\ncccc\ndddd\n\n".getBytes();
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put("test", "test-value");
        ValueExpressionEvaluationInputStream inputStream = new ValueExpressionEvaluationInputStream(FacesContext.getCurrentInstance(), (InputStream)new ByteArrayInputStream(dataArray));
        byte[] inputStreamDataArray = new byte[dataArray.length];
        inputStream.read(inputStreamDataArray);
        Assert.assertArrayEquals((byte[])dataArray, (byte[])inputStreamDataArray);
        Assert.assertEquals((long)-1L, (long)inputStream.read());
    }

    @Test
    public void testStreamWithExpressionEvaluatingToExpressionString_mustOnlyEvaluateFirstExpression() throws Exception {
        String data = "aa\nbbbb\ncc#{requestScope.test}cc\ndddd\n\n";
        String evaluatedData = "aa\nbbbb\ncc#{requestScope.test2}cc\ndddd\n\n";
        byte[] dataArray = "aa\nbbbb\ncc#{requestScope.test}cc\ndddd\n\n".getBytes();
        byte[] evaluatedDataArray = "aa\nbbbb\ncc#{requestScope.test2}cc\ndddd\n\n".getBytes();
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put("test", "#{requestScope.test2}");
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put("test2", "test-value");
        ValueExpressionEvaluationInputStream inputStream = new ValueExpressionEvaluationInputStream(FacesContext.getCurrentInstance(), (InputStream)new ByteArrayInputStream(dataArray));
        byte[] inputStreamDataArray = new byte[evaluatedDataArray.length];
        inputStream.read(inputStreamDataArray);
        Assert.assertArrayEquals((byte[])evaluatedDataArray, (byte[])inputStreamDataArray);
        Assert.assertEquals((long)-1L, (long)inputStream.read());
    }

    @Test
    public void testStreamThatOnlyConsistsOfExpression_mustEvaluateExpression() throws Exception {
        String data = "#{requestScope.test}";
        String evaluatedData = "test-value";
        byte[] dataArray = "#{requestScope.test}".getBytes();
        byte[] evaluatedDataArray = "test-value".getBytes();
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put("test", "test-value");
        ValueExpressionEvaluationInputStream inputStream = new ValueExpressionEvaluationInputStream(FacesContext.getCurrentInstance(), (InputStream)new ByteArrayInputStream(dataArray));
        byte[] inputStreamDataArray = new byte[evaluatedDataArray.length];
        inputStream.read(inputStreamDataArray);
        Assert.assertArrayEquals((byte[])evaluatedDataArray, (byte[])inputStreamDataArray);
        Assert.assertEquals((long)-1L, (long)inputStream.read());
    }

    @Test
    public void testStreamWithNullExpression_mustEvaluateToEmptyString() throws Exception {
        String data = "aa\nbbbb\ncc#{requestScope.test}cc\ndddd\n\n";
        String evaluatedData = "aa\nbbbb\ncccc\ndddd\n\n";
        byte[] dataArray = "aa\nbbbb\ncc#{requestScope.test}cc\ndddd\n\n".getBytes();
        byte[] evaluatedDataArray = "aa\nbbbb\ncccc\ndddd\n\n".getBytes();
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove("test");
        ValueExpressionEvaluationInputStream inputStream = new ValueExpressionEvaluationInputStream(FacesContext.getCurrentInstance(), (InputStream)new ByteArrayInputStream(dataArray));
        byte[] inputStreamDataArray = new byte[evaluatedDataArray.length];
        inputStream.read(inputStreamDataArray);
        Assert.assertArrayEquals((byte[])evaluatedDataArray, (byte[])inputStreamDataArray);
        Assert.assertEquals((long)-1L, (long)inputStream.read());
    }
}

