/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.spi.scope.window;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindowConfig;

@SessionScoped
public class DefaultClientWindowConfig
implements ClientWindowConfig,
Serializable {
    public static final String COOKIE_NAME_NOSCRIPT_ENABLED = "deltaspikeNoScriptEnabled";
    private static final String DEFAULT_WINDOW_HANDLER_HTML_FILE = "static/windowhandler.html";
    private volatile Boolean javaScriptEnabled = null;
    private volatile String userAgent = null;
    private String clientWindowtml;
    @Inject
    private ProjectStage projectStage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isJavaScriptEnabled() {
        if (this.javaScriptEnabled == null) {
            DefaultClientWindowConfig defaultClientWindowConfig = this;
            synchronized (defaultClientWindowConfig) {
                if (this.javaScriptEnabled == null) {
                    Cookie cookie;
                    this.javaScriptEnabled = Boolean.TRUE;
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    if (facesContext != null && (cookie = (Cookie)facesContext.getExternalContext().getRequestCookieMap().get(COOKIE_NAME_NOSCRIPT_ENABLED)) != null) {
                        this.javaScriptEnabled = Boolean.parseBoolean(cookie.getValue());
                    }
                }
            }
        }
        return this.javaScriptEnabled;
    }

    @Override
    public void setJavaScriptEnabled(boolean javaScriptEnabled) {
        this.javaScriptEnabled = javaScriptEnabled;
    }

    @Override
    public ClientWindowConfig.ClientWindowRenderMode getClientWindowRenderMode(FacesContext facesContext) {
        if (!this.isJavaScriptEnabled()) {
            return ClientWindowConfig.ClientWindowRenderMode.NONE;
        }
        String userAgent = this.getUserAgent(facesContext);
        if (userAgent != null && (userAgent.indexOf("bot") >= 0 || userAgent.indexOf("Bot") >= 0 || userAgent.indexOf("Slurp") >= 0 || userAgent.indexOf("Crawler") >= 0)) {
            return ClientWindowConfig.ClientWindowRenderMode.NONE;
        }
        return ClientWindowConfig.ClientWindowRenderMode.CLIENTWINDOW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClientWindowHtml() {
        if (this.projectStage != ProjectStage.Development && this.clientWindowtml != null) {
            return this.clientWindowtml;
        }
        InputStream is = ClassUtils.getClassLoader(null).getResourceAsStream(this.getClientWindowResourceLocation());
        StringBuffer sb = new StringBuffer();
        try {
            int bytesRead;
            byte[] buf = new byte[16384];
            while ((bytesRead = is.read(buf)) != -1) {
                String sbuf = new String(buf, 0, bytesRead);
                sb.append(sbuf);
            }
        }
        catch (IOException e) {
            ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        this.clientWindowtml = sb.toString();
        return this.clientWindowtml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserAgent(FacesContext facesContext) {
        if (this.userAgent == null) {
            DefaultClientWindowConfig defaultClientWindowConfig = this;
            synchronized (defaultClientWindowConfig) {
                Map requestHeaders;
                if (this.userAgent == null && (requestHeaders = facesContext.getExternalContext().getRequestHeaderValuesMap()) != null && requestHeaders.containsKey("User-Agent")) {
                    String[] userAgents = (String[])requestHeaders.get("User-Agent");
                    this.userAgent = userAgents.length > 0 ? userAgents[0] : null;
                }
            }
        }
        return this.userAgent;
    }

    public String getClientWindowResourceLocation() {
        return DEFAULT_WINDOW_HANDLER_HTML_FILE;
    }
}

