/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.jpa.api.transactionscoped.nested;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.persistence.EntityManager;
import org.apache.deltaspike.jpa.api.transaction.TransactionScoped;
import org.apache.deltaspike.test.jpa.api.shared.First;
import org.apache.deltaspike.test.jpa.api.shared.TestEntityManager;

@RequestScoped
public class TestEntityManagerProducer {
    private TestEntityManager firstEntityManager;
    private int closeEntityManagerCount = 0;

    @Produces
    @First
    @TransactionScoped
    protected EntityManager firstEntityManager() {
        if (this.firstEntityManager == null) {
            this.firstEntityManager = new TestEntityManager();
            return this.firstEntityManager;
        }
        throw new IllegalStateException("a second producer call isn't allowed");
    }

    protected void closeEntityManager(@Disposes @First EntityManager entityManager) {
        if (entityManager.isOpen()) {
            entityManager.close();
        }
        ++this.closeEntityManagerCount;
    }

    public int getCloseEntityManagerCount() {
        return this.closeEntityManagerCount;
    }

    public TestEntityManager getFirstEntityManager() {
        return this.firstEntityManager;
    }
}

