/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.jpa.api.transactionscoped.multipleinjection.nested;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.persistence.EntityManager;
import org.apache.deltaspike.jpa.api.transaction.TransactionScoped;
import org.apache.deltaspike.test.jpa.api.shared.First;
import org.apache.deltaspike.test.jpa.api.shared.Second;
import org.apache.deltaspike.test.jpa.api.shared.TestEntityManager;

@RequestScoped
public class TestEntityManagerProducer {
    private TestEntityManager firstEntityManager;
    private TestEntityManager secondEntityManager;
    private int closeEntityManagerCountFirstEntityManager = 0;
    private int closeEntityManagerCountSecondEntityManager = 0;

    @Produces
    @First
    @TransactionScoped
    protected EntityManager firstEntityManager() {
        if (this.firstEntityManager == null) {
            this.firstEntityManager = new TestEntityManager();
            return this.firstEntityManager;
        }
        throw new IllegalStateException("a second producer call isn't allowed");
    }

    @Produces
    @Second
    @TransactionScoped
    protected EntityManager secondEntityManager() {
        if (this.secondEntityManager == null) {
            this.secondEntityManager = new TestEntityManager();
            return this.secondEntityManager;
        }
        throw new IllegalStateException("a second producer call isn't allowed");
    }

    protected void closeFirstEntityManager(@Disposes @First EntityManager entityManager) {
        if (entityManager.isOpen()) {
            entityManager.close();
        }
        ++this.closeEntityManagerCountFirstEntityManager;
    }

    protected void closeSecondEntityManager(@Disposes @Second EntityManager entityManager) {
        if (entityManager.isOpen()) {
            entityManager.close();
        }
        ++this.closeEntityManagerCountSecondEntityManager;
    }

    public TestEntityManager getFirstEntityManager() {
        return this.firstEntityManager;
    }

    public TestEntityManager getSecondEntityManager() {
        return this.secondEntityManager;
    }

    public int getCloseEntityManagerCountFirstEntityManager() {
        return this.closeEntityManagerCountFirstEntityManager;
    }

    public int getCloseEntityManagerCountSecondEntityManager() {
        return this.closeEntityManagerCountSecondEntityManager;
    }
}

