/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.jpa.api.transactionscoped.multipleinjection.nested;

import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.util.ProjectStageProducer;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionBeanStorage;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionContextExtension;
import org.apache.deltaspike.test.category.SeCategory;
import org.apache.deltaspike.test.jpa.api.shared.TestEntityManager;
import org.apache.deltaspike.test.jpa.api.shared.TestEntityTransaction;
import org.apache.deltaspike.test.jpa.api.transactionscoped.multipleinjection.nested.FirstLevelTransactionBean;
import org.apache.deltaspike.test.jpa.api.transactionscoped.multipleinjection.nested.TestEntityManagerProducer;
import org.apache.deltaspike.test.util.ArchiveUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={SeCategory.class})
public class NestedMultiTransactionScopedTransactionTest {
    @Inject
    private FirstLevelTransactionBean firstLevelTransactionBean;
    @Inject
    private TestEntityManagerProducer entityManagerProducer;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"nestedMultiTransactionScopedTransactionTest.jar")).addPackage(ArchiveUtils.SHARED_PACKAGE)).addPackage(NestedMultiTransactionScopedTransactionTest.class.getPackage().getName())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndJpaArchive())).addAsLibraries(new Archive[]{testJar})).addAsServiceProvider(Extension.class, new Class[]{TransactionContextExtension.class})).addAsWebInfResource(ArchiveUtils.getBeansXml(), "beans.xml");
    }

    @Before
    public void init() {
        ProjectStageProducer.setProjectStage((ProjectStage)ProjectStage.UnitTest);
    }

    @Test
    public void nestedMultiTransactionScopedTransactionTest() {
        this.firstLevelTransactionBean.executeInTransaction();
        TestEntityManager firstEntityManager = this.entityManagerProducer.getFirstEntityManager();
        TestEntityManager secondEntityManager = this.entityManagerProducer.getSecondEntityManager();
        Assert.assertNotNull((Object)firstEntityManager);
        TestEntityTransaction firstTransaction = (TestEntityTransaction)firstEntityManager.getTransaction();
        Assert.assertNotNull((Object)secondEntityManager);
        TestEntityTransaction secondTransaction = (TestEntityTransaction)secondEntityManager.getTransaction();
        Assert.assertEquals((Object)true, (Object)firstEntityManager.isFlushed());
        Assert.assertEquals((Object)false, (Object)firstTransaction.isActive());
        Assert.assertEquals((Object)true, (Object)firstTransaction.isStarted());
        Assert.assertEquals((Object)true, (Object)firstTransaction.isCommitted());
        Assert.assertEquals((Object)false, (Object)firstTransaction.isRolledBack());
        Assert.assertEquals((Object)true, (Object)secondEntityManager.isFlushed());
        Assert.assertEquals((Object)false, (Object)secondTransaction.isActive());
        Assert.assertEquals((Object)true, (Object)secondTransaction.isStarted());
        Assert.assertEquals((Object)true, (Object)secondTransaction.isCommitted());
        Assert.assertEquals((Object)false, (Object)secondTransaction.isRolledBack());
        Assert.assertEquals((long)1L, (long)this.entityManagerProducer.getCloseEntityManagerCountFirstEntityManager());
        Assert.assertEquals((long)1L, (long)this.entityManagerProducer.getCloseEntityManagerCountSecondEntityManager());
        Assert.assertEquals((Object)false, (Object)TransactionBeanStorage.isOpen());
    }
}

