/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.jpa.api.transactional.transactionhelper;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.spi.Extension;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.jpa.api.transaction.TransactionHelper;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionBeanStorage;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionContextExtension;
import org.apache.deltaspike.test.category.SeCategory;
import org.apache.deltaspike.test.util.ArchiveUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={SeCategory.class})
public class TransactionHelperTest {
    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"defaultInjectionTest.jar")).addPackage(ArchiveUtils.SHARED_PACKAGE)).addPackage(TransactionHelperTest.class.getPackage().getName())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndJpaArchive())).addAsLibraries(new Archive[]{testJar})).addAsServiceProvider(Extension.class, new Class[]{TransactionContextExtension.class})).addAsWebInfResource(ArchiveUtils.getBeansXml(), "beans.xml");
    }

    @Test
    public void testTransactionHelper() throws Exception {
        try {
            this.resolveEntityManager();
            Assert.fail((String)"ContextNotActiveException expected!");
        }
        catch (ContextNotActiveException cnae) {
            // empty catch block
        }
        Integer retVal = (Integer)TransactionHelper.getInstance().executeTransactional((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                TransactionHelperTest.this.resolveEntityManager();
                return 3;
            }
        });
        Assert.assertEquals((Object)retVal, (Object)3);
        try {
            this.resolveEntityManager();
            Assert.fail((String)"ContextNotActiveException expected!");
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
        Assert.assertEquals((Object)false, (Object)TransactionBeanStorage.isOpen());
    }

    private void resolveEntityManager() {
        EntityManager em = (EntityManager)BeanProvider.getContextualReference(EntityManager.class, (Annotation[])new Annotation[0]);
        Assert.assertNotNull((Object)em);
        EntityTransaction et = em.getTransaction();
        Assert.assertNotNull((Object)et);
    }
}

