/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.jpa.api.transactional.readonly.auto;

import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.util.ProjectStageProducer;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionBeanStorage;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionContextExtension;
import org.apache.deltaspike.test.category.SeCategory;
import org.apache.deltaspike.test.jpa.api.shared.TestEntityManager;
import org.apache.deltaspike.test.jpa.api.shared.TestEntityTransaction;
import org.apache.deltaspike.test.jpa.api.transactional.readonly.auto.MultiTransactionBean;
import org.apache.deltaspike.test.jpa.api.transactional.readonly.auto.TestEntityManagerProducer;
import org.apache.deltaspike.test.util.ArchiveUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={SeCategory.class})
public class MultipleEntityManagerInjectionReadOnlyTest {
    @Inject
    private MultiTransactionBean multiTransactionBean;
    @Inject
    private TestEntityManagerProducer entityManagerProducer;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"multipleEntityManagerInjectionReadOnlyTest.jar")).addPackage(ArchiveUtils.SHARED_PACKAGE)).addPackage(MultipleEntityManagerInjectionReadOnlyTest.class.getPackage().getName())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndJpaArchive())).addAsLibraries(new Archive[]{testJar})).addAsServiceProvider(Extension.class, new Class[]{TransactionContextExtension.class})).addAsWebInfResource(ArchiveUtils.getBeansXml(), "beans.xml");
    }

    @Before
    public void init() {
        ProjectStageProducer.setProjectStage((ProjectStage)ProjectStage.UnitTest);
    }

    @Test
    public void autoInjectionReadOnlyTest() {
        TestEntityManager defaultEntityManager = this.entityManagerProducer.getDefaultEntityManager();
        TestEntityManager firstEntityManager = this.entityManagerProducer.getFirstEntityManager();
        TestEntityManager secondEntityManager = this.entityManagerProducer.getSecondEntityManager();
        Assert.assertNotNull((Object)defaultEntityManager);
        TestEntityTransaction defaultTransaction = (TestEntityTransaction)defaultEntityManager.getTransaction();
        Assert.assertEquals((Object)false, (Object)defaultEntityManager.isFlushed());
        Assert.assertEquals((Object)false, (Object)defaultTransaction.isActive());
        Assert.assertEquals((Object)false, (Object)defaultTransaction.isStarted());
        Assert.assertEquals((Object)false, (Object)defaultTransaction.isCommitted());
        Assert.assertEquals((Object)false, (Object)defaultTransaction.isRolledBack());
        Assert.assertNotNull((Object)firstEntityManager);
        TestEntityTransaction firstTransaction = (TestEntityTransaction)firstEntityManager.getTransaction();
        Assert.assertEquals((Object)false, (Object)firstEntityManager.isFlushed());
        Assert.assertEquals((Object)false, (Object)firstTransaction.isActive());
        Assert.assertEquals((Object)false, (Object)firstTransaction.isStarted());
        Assert.assertEquals((Object)false, (Object)firstTransaction.isCommitted());
        Assert.assertEquals((Object)false, (Object)firstTransaction.isRolledBack());
        Assert.assertNotNull((Object)secondEntityManager);
        TestEntityTransaction secondTransaction = (TestEntityTransaction)secondEntityManager.getTransaction();
        Assert.assertEquals((Object)false, (Object)secondEntityManager.isFlushed());
        Assert.assertEquals((Object)false, (Object)secondTransaction.isActive());
        Assert.assertEquals((Object)false, (Object)secondTransaction.isStarted());
        Assert.assertEquals((Object)false, (Object)secondTransaction.isCommitted());
        Assert.assertEquals((Object)false, (Object)secondTransaction.isRolledBack());
        this.multiTransactionBean.executeInTransaction();
        Assert.assertEquals((Object)false, (Object)defaultEntityManager.isFlushed());
        Assert.assertEquals((Object)false, (Object)defaultTransaction.isActive());
        Assert.assertEquals((Object)true, (Object)defaultTransaction.isStarted());
        Assert.assertEquals((Object)false, (Object)defaultTransaction.isCommitted());
        Assert.assertEquals((Object)true, (Object)defaultTransaction.isRolledBack());
        Assert.assertEquals((Object)false, (Object)firstEntityManager.isFlushed());
        Assert.assertEquals((Object)false, (Object)firstTransaction.isActive());
        Assert.assertEquals((Object)true, (Object)firstTransaction.isStarted());
        Assert.assertEquals((Object)false, (Object)firstTransaction.isCommitted());
        Assert.assertEquals((Object)true, (Object)firstTransaction.isRolledBack());
        Assert.assertEquals((Object)false, (Object)secondEntityManager.isFlushed());
        Assert.assertEquals((Object)false, (Object)secondTransaction.isActive());
        Assert.assertEquals((Object)true, (Object)secondTransaction.isStarted());
        Assert.assertEquals((Object)false, (Object)secondTransaction.isCommitted());
        Assert.assertEquals((Object)true, (Object)secondTransaction.isRolledBack());
        Assert.assertEquals((Object)false, (Object)TransactionBeanStorage.isOpen());
    }
}

