/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.jpa.api.transactionscoped.stereotype;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.persistence.EntityManager;
import org.apache.deltaspike.jpa.api.transaction.TransactionScoped;
import org.apache.deltaspike.test.jpa.api.shared.TestEntityManager;

@RequestScoped
public class TestEntityManagerProducer {
    private TestEntityManager entityManager;
    private int closeEntityManagerCount = 0;

    @Produces
    @TransactionScoped
    protected EntityManager entityManager() {
        if (this.entityManager == null) {
            this.entityManager = new TestEntityManager();
            return this.entityManager;
        }
        throw new IllegalStateException("a second producer call isn't allowed");
    }

    protected void closeEntityManager(@Disposes EntityManager entityManager) {
        if (entityManager.isOpen()) {
            entityManager.close();
        }
        ++this.closeEntityManagerCount;
    }

    public int getCloseEntityManagerCount() {
        return this.closeEntityManagerCount;
    }
}

