/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.jpa.api.transactionscoped.defaultinjection;

import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.util.ProjectStageProducer;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionBeanStorage;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionContextExtension;
import org.apache.deltaspike.test.category.SeCategory;
import org.apache.deltaspike.test.jpa.api.shared.TestEntityTransaction;
import org.apache.deltaspike.test.jpa.api.transactionscoped.defaultinjection.TestEntityManagerProducer;
import org.apache.deltaspike.test.jpa.api.transactionscoped.defaultinjection.TransactionalBean;
import org.apache.deltaspike.test.util.ArchiveUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={SeCategory.class})
public class DefaultTransactionScopedEntityManagerInjectionTest {
    @Inject
    private TransactionalBean transactionalBean;
    @Inject
    private EntityManager entityManager;
    @Inject
    private TestEntityManagerProducer entityManagerProducer;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"defaultTransactionScopedInjectionTest.jar")).addPackage(ArchiveUtils.SHARED_PACKAGE)).addPackage(DefaultTransactionScopedEntityManagerInjectionTest.class.getPackage().getName())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndJpaArchive())).addAsLibraries(new Archive[]{testJar})).addAsServiceProvider(Extension.class, new Class[]{TransactionContextExtension.class})).addAsWebInfResource(ArchiveUtils.getBeansXml(), "beans.xml");
    }

    @Before
    public void init() {
        ProjectStageProducer.setProjectStage((ProjectStage)ProjectStage.UnitTest);
    }

    @Test
    public void defaultTransactionScopedEntityManagerInjection() {
        this.transactionalBean.executeInTransaction();
        TestEntityTransaction testTransaction = (TestEntityTransaction)this.entityManagerProducer.getEntityManager().getTransaction();
        Assert.assertEquals((Object)false, (Object)testTransaction.isActive());
        Assert.assertEquals((Object)true, (Object)testTransaction.isStarted());
        Assert.assertEquals((Object)true, (Object)testTransaction.isCommitted());
        Assert.assertEquals((Object)false, (Object)testTransaction.isRolledBack());
        Assert.assertEquals((long)1L, (long)this.entityManagerProducer.getCloseEntityManagerCount());
        Assert.assertEquals((Object)false, (Object)TransactionBeanStorage.isOpen());
    }

    @Test
    public void entityManagerUsageWithoutTransaction() {
        try {
            this.entityManager.getTransaction();
            Assert.fail((String)(ContextNotActiveException.class.getName() + " expected!"));
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
        Assert.assertEquals((Object)false, (Object)TransactionBeanStorage.isOpen());
    }

    @Test
    public void invalidEntityManagerUsageAfterTransaction() {
        try {
            this.entityManager.getTransaction();
            Assert.fail((String)(ContextNotActiveException.class.getName() + " expected!"));
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
        Assert.assertEquals((Object)false, (Object)TransactionBeanStorage.isOpen());
    }
}

