/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.jpa.api.shared;

import javax.persistence.EntityTransaction;

public class TestEntityTransaction
implements EntityTransaction {
    private boolean started = false;
    private boolean committed = false;
    private boolean rolledBack = false;
    private boolean markRolledBack = false;

    public void begin() {
        if (this.started) {
            throw new IllegalStateException("transaction started already");
        }
        this.started = true;
    }

    public void commit() {
        this.committed = true;
    }

    public void rollback() {
        this.rolledBack = true;
    }

    public void setRollbackOnly() {
        this.markRolledBack = true;
    }

    public boolean getRollbackOnly() {
        return this.markRolledBack;
    }

    public boolean isActive() {
        return this.started && !this.committed && !this.rolledBack;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isRolledBack() {
        return this.rolledBack;
    }
}

