/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.jpa.api.entitymanager;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import org.apache.deltaspike.test.category.SeCategory;
import org.apache.deltaspike.test.jpa.api.entitymanager.SampleDb;
import org.apache.deltaspike.test.jpa.api.entitymanager.TestPersistenceProviderResolver;
import org.apache.deltaspike.test.jpa.api.shared.TestEntityManager;
import org.apache.deltaspike.test.util.ArchiveUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={SeCategory.class})
public class EntityManagerFactoryProducerTest {
    @Inject
    @SampleDb
    private EntityManager entityManager;

    @Deployment
    public static WebArchive deploy() {
        PersistenceProviderResolverHolder.setPersistenceProviderResolver((PersistenceProviderResolver)new TestPersistenceProviderResolver());
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"unitDefinitionTest.jar")).addPackage(ArchiveUtils.SHARED_PACKAGE)).addPackage(EntityManagerFactoryProducerTest.class.getPackage().getName())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsResource((Asset)new StringAsset(TestPersistenceProviderResolver.class.getName()), "META-INF/services/javax.persistence.spi.PersistenceProviderResolver");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndJpaArchive())).addAsLibraries(new Archive[]{testJar})).addAsWebInfResource(ArchiveUtils.getBeansXml(), "beans.xml");
    }

    @Test
    public void testUnitDefinitionQualifier() throws Exception {
        Assert.assertNotNull((Object)this.entityManager);
        Assert.assertNotNull((Object)this.entityManager.getDelegate());
        Assert.assertTrue((boolean)(this.entityManager.getDelegate() instanceof TestEntityManager));
        TestEntityManager tem = (TestEntityManager)this.entityManager.getDelegate();
        Assert.assertEquals((Object)"testPersistenceUnit", (Object)tem.getUnitName());
    }
}

