/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.beanvalidation.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ReflectionUtils;

public class CDIAwareConstraintValidatorFactory
implements ConstraintValidatorFactory {
    private static final String RELEASE_INSTANCE_METHOD_NAME = "releaseInstance";
    private static Boolean releaseInstanceMethodFound;
    private static Method releaseInstanceMethod;
    private final Logger log = Logger.getLogger(CDIAwareConstraintValidatorFactory.class.toString());
    private final ConstraintValidatorFactory delegate = Validation.byDefaultProvider().configure().getDefaultConstraintValidatorFactory();

    public CDIAwareConstraintValidatorFactory() {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Setting up delegate ConstraintValidatorFactory as " + this.delegate.getClass().getCanonicalName());
        }
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> validatorClass) {
        ConstraintValidator resolvedInst = (ConstraintValidator)BeanProvider.getContextualReference(validatorClass, (boolean)true, (Annotation[])new Annotation[0]);
        if (resolvedInst == null) {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("No contextual instances found for class " + validatorClass.getCanonicalName() + " delegating to DefaultProvider behavior.");
            }
            resolvedInst = this.delegate.getInstance(validatorClass);
        }
        return (T)resolvedInst;
    }

    public void releaseInstance(ConstraintValidator<?, ?> constraintValidator) {
        if (releaseInstanceMethodFound == null) {
            this.lazyInit();
        }
        if (Boolean.TRUE.equals(releaseInstanceMethodFound)) {
            ReflectionUtils.invokeMethod((Object)this.delegate, (Method)releaseInstanceMethod, Void.class, (boolean)true, (Object[])new Object[]{constraintValidator});
        }
    }

    private synchronized void lazyInit() {
        if (releaseInstanceMethodFound != null) {
            return;
        }
        for (Class<?> currentClass = this.delegate.getClass(); currentClass != null && !Object.class.getName().equals(currentClass.getName()); currentClass = currentClass.getSuperclass()) {
            for (Method currentMethod : currentClass.getDeclaredMethods()) {
                if (!RELEASE_INSTANCE_METHOD_NAME.equals(currentMethod.getName()) || currentMethod.getParameterTypes().length != 1 || !currentMethod.getParameterTypes()[0].equals(ConstraintValidator.class)) continue;
                releaseInstanceMethod = currentMethod;
                releaseInstanceMethodFound = true;
                return;
            }
        }
        releaseInstanceMethodFound = false;
    }
}

