/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.beanvalidation.test;

import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.deltaspike.beanvalidation.impl.CDIAwareConstraintValidatorFactory;
import org.apache.deltaspike.beanvalidation.test.ArchiveUtils;
import org.apache.deltaspike.beanvalidation.test.ArrayChecker;
import org.apache.deltaspike.beanvalidation.test.ArraySize;
import org.apache.deltaspike.beanvalidation.test.BasicPojo;
import org.apache.deltaspike.beanvalidation.test.InjectableConstraintValidator;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class InjectedValidationTest {
    private Validator validator;

    @Deployment
    public static WebArchive createArchive() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"beanval.war")).addClasses(new Class[]{BasicPojo.class, InjectableConstraintValidator.class, CDIAwareConstraintValidatorFactory.class, ArraySize.class, ArrayChecker.class})).addAsWebInfResource("validation.xml", "classes/META-INF/validation.xml")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCore());
    }

    @Before
    public void initValidator() {
        this.validator = Validation.byDefaultProvider().configure().constraintValidatorFactory((ConstraintValidatorFactory)new CDIAwareConstraintValidatorFactory()).buildValidatorFactory().getValidator();
    }

    @Test
    public void testValidate() {
        String[] entries = new String[]{"abc", "def", "ghi"};
        BasicPojo p = new BasicPojo();
        p.setValue(entries);
        Set violations = this.validator.validate((Object)p, new Class[0]);
        StringBuilder sb = new StringBuilder();
        for (ConstraintViolation violation : violations) {
            sb.append(violation.getMessage() + " " + violation.getPropertyPath());
        }
        Assert.assertTrue((String)sb.toString(), (boolean)violations.isEmpty());
    }
}

