/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.beanValidation.impl;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import org.apache.deltaspike.core.api.provider.BeanProvider;

public class CDIAwareConstraintValidatorFactory
implements ConstraintValidatorFactory {
    private final Logger log = Logger.getLogger(CDIAwareConstraintValidatorFactory.class.toString());
    private final ConstraintValidatorFactory delegate = Validation.byDefaultProvider().configure().getDefaultConstraintValidatorFactory();

    public CDIAwareConstraintValidatorFactory() {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Setting up delegate ConstraintValidatorFactory as " + this.delegate.getClass().getCanonicalName());
        }
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> validatorClass) {
        ConstraintValidator resolvedInst = null;
        resolvedInst = (ConstraintValidator)BeanProvider.getContextualReference(validatorClass, (boolean)true, (Annotation[])new Annotation[0]);
        if (resolvedInst == null) {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("No contextual instances found for class " + validatorClass.getCanonicalName() + " delegating to DefaultProvider behavior.");
            }
            resolvedInst = this.delegate.getInstance(validatorClass);
        }
        return (T)resolvedInst;
    }
}

