/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.comet.execution.shuffle;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.comet.CometConf;
import org.apache.comet.Native;
import org.apache.comet.serde.ExprOuterClass;
import org.apache.comet.serde.QueryPlanSerde$;
import org.apache.spark.memory.SparkOutOfMemoryError;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.comet.CometShuffleMemoryAllocatorTrait;
import org.apache.spark.shuffle.sort.RowPartition;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpillWriter {
    private static final Logger logger = LoggerFactory.getLogger(SpillWriter.class);
    protected LinkedList<MemoryBlock> allocatedPages;
    @Nullable
    protected MemoryBlock currentPage = null;
    protected long pageCursor = -1L;
    protected CometShuffleMemoryAllocatorTrait allocator;
    protected Native nativeLib;
    protected byte[][] dataTypes;
    protected int checksumAlgo = 1;
    protected long checksum = -1L;

    protected byte[][] serializeSchema(StructType schema) {
        byte[][] dataTypes = new byte[schema.length()][];
        for (int i = 0; i < schema.length(); ++i) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                ((ExprOuterClass.DataType)QueryPlanSerde$.MODULE$.serializeDataType(schema.apply(i).dataType()).get()).writeTo(outputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            dataTypes[i] = outputStream.toByteArray();
        }
        return dataTypes;
    }

    protected void setChecksumAlgo(String checksumAlgo) {
        String algo = checksumAlgo.toLowerCase(Locale.ROOT);
        if (algo.equals("crc32")) {
            this.checksumAlgo = 0;
        } else if (algo.equals("adler32")) {
            this.checksumAlgo = 1;
        } else {
            throw new UnsupportedOperationException("Unsupported shuffle checksum algorithm: " + checksumAlgo);
        }
    }

    protected void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    protected long getChecksum() {
        return this.checksum;
    }

    protected abstract void spill(int var1) throws IOException;

    public boolean acquireNewPageIfNecessary(int required) {
        if (this.currentPage == null || this.pageCursor + (long)required > this.currentPage.getBaseOffset() + this.currentPage.size()) {
            try {
                this.currentPage = this.allocator.allocate(required);
            }
            catch (SparkOutOfMemoryError error) {
                try {
                    this.spill(required);
                    return false;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to spill() in order to acquire " + required, e);
                }
            }
            assert (this.currentPage != null);
            this.pageCursor = this.currentPage.getBaseOffset();
            this.allocatedPages.add(this.currentPage);
        }
        return true;
    }

    public void initialCurrentPage(int required) {
        assert (this.currentPage == null);
        try {
            this.currentPage = this.allocator.allocate(required);
        }
        catch (SparkOutOfMemoryError e) {
            logger.error("Unable to acquire {} bytes of memory", (Object)required);
            throw e;
        }
        assert (this.currentPage != null);
        this.pageCursor = this.currentPage.getBaseOffset();
        this.allocatedPages.add(this.currentPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doSpilling(byte[][] dataTypes, File file, RowPartition rowPartition, ShuffleWriteMetricsReporter writeMetricsToUse, double preferDictionaryRatio, String compressionCodec, int compressionLevel) {
        long[] addresses = rowPartition.getRowAddresses();
        int[] sizes = rowPartition.getRowSizes();
        boolean checksumEnabled = this.checksum != -1L;
        long currentChecksum = checksumEnabled ? this.checksum : 0L;
        long start = System.nanoTime();
        int batchSize = (Integer)CometConf.COMET_COLUMNAR_SHUFFLE_BATCH_SIZE().get();
        boolean enableFastEncoding = (Boolean)CometConf.COMET_SHUFFLE_ENABLE_FAST_ENCODING().get();
        long[] results = this.nativeLib.writeSortedFileNative(addresses, sizes, dataTypes, file.getAbsolutePath(), preferDictionaryRatio, batchSize, checksumEnabled, this.checksumAlgo, currentChecksum, compressionCodec, compressionLevel, enableFastEncoding);
        long written = results[0];
        this.checksum = results[1];
        rowPartition.reset();
        ShuffleWriteMetricsReporter shuffleWriteMetricsReporter = writeMetricsToUse;
        synchronized (shuffleWriteMetricsReporter) {
            writeMetricsToUse.incWriteTime(System.nanoTime() - start);
            writeMetricsToUse.incRecordsWritten((long)addresses.length);
            writeMetricsToUse.incBytesWritten(written);
        }
        return written;
    }

    public long freeMemory() {
        long freed = 0L;
        for (MemoryBlock block : this.allocatedPages) {
            freed += block.size();
            this.allocator.free(block);
        }
        this.allocatedPages.clear();
        this.currentPage = null;
        this.pageCursor = 0L;
        return freed;
    }

    public long getMemoryUsage() {
        long used = 0L;
        for (MemoryBlock block : this.allocatedPages) {
            used += block.size();
        }
        return used;
    }
}

