/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.comet;

import java.util.HashMap;
import org.apache.comet.CometRuntimeException;
import org.apache.spark.sql.execution.ScalarSubquery;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;

public class CometScalarSubquery {
    private static final HashMap<Long, HashMap<Long, ScalarSubquery>> subqueryMap = new HashMap();

    public static synchronized void setSubquery(long planId, ScalarSubquery subquery) {
        if (!subqueryMap.containsKey(planId)) {
            subqueryMap.put(planId, new HashMap());
        }
        subqueryMap.get(planId).put(subquery.exprId().id(), subquery);
    }

    public static synchronized void removeSubquery(long planId, ScalarSubquery subquery) {
        if (subqueryMap.containsKey(planId)) {
            subqueryMap.get(planId).remove(subquery.exprId().id());
            if (subqueryMap.get(planId).isEmpty()) {
                subqueryMap.remove(planId);
            }
        }
    }

    private static Object getSubquery(Long planId, Long id) {
        if (!subqueryMap.containsKey(planId)) {
            throw new CometRuntimeException("Subquery " + id + " not found for plan " + planId + ".");
        }
        return subqueryMap.get(planId).get(id).eval(null);
    }

    public static boolean isNull(long planId, long id) {
        return CometScalarSubquery.getSubquery(planId, id) == null;
    }

    public static boolean getBoolean(long planId, long id) {
        return (Boolean)CometScalarSubquery.getSubquery(planId, id);
    }

    public static byte getByte(long planId, long id) {
        return (Byte)CometScalarSubquery.getSubquery(planId, id);
    }

    public static short getShort(long planId, long id) {
        return (Short)CometScalarSubquery.getSubquery(planId, id);
    }

    public static int getInt(long planId, long id) {
        return (Integer)CometScalarSubquery.getSubquery(planId, id);
    }

    public static long getLong(long planId, long id) {
        return (Long)CometScalarSubquery.getSubquery(planId, id);
    }

    public static float getFloat(long planId, long id) {
        return ((Float)CometScalarSubquery.getSubquery(planId, id)).floatValue();
    }

    public static double getDouble(long planId, long id) {
        return (Double)CometScalarSubquery.getSubquery(planId, id);
    }

    public static byte[] getDecimal(long planId, long id) {
        return ((Decimal)CometScalarSubquery.getSubquery(planId, id)).toJavaBigDecimal().unscaledValue().toByteArray();
    }

    public static String getString(long planId, long id) {
        return ((UTF8String)CometScalarSubquery.getSubquery(planId, id)).toString();
    }

    public static byte[] getBinary(long planId, long id) {
        return (byte[])CometScalarSubquery.getSubquery(planId, id);
    }
}

