/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.comet;

import java.io.IOException;
import org.apache.comet.CometConf$;
import org.apache.spark.SparkConf;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.shuffle.comet.CometShuffleMemoryAllocatorTrait;
import org.apache.spark.shuffle.comet.CometTestShuffleMemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.util.Utils;

public final class CometShuffleMemoryAllocator
extends CometShuffleMemoryAllocatorTrait {
    private static CometShuffleMemoryAllocatorTrait INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CometShuffleMemoryAllocatorTrait getInstance(SparkConf conf, TaskMemoryManager taskMemoryManager, long pageSize) {
        boolean isSparkTesting = Utils.isTesting();
        boolean useUnifiedMemAllocator = (Boolean)CometConf$.MODULE$.COMET_COLUMNAR_SHUFFLE_UNIFIED_MEMORY_ALLOCATOR_IN_TEST().get();
        if (!useUnifiedMemAllocator) {
            Class<CometShuffleMemoryAllocator> clazz = CometShuffleMemoryAllocator.class;
            synchronized (CometShuffleMemoryAllocator.class) {
                if (INSTANCE == null) {
                    INSTANCE = new CometTestShuffleMemoryAllocator(conf, taskMemoryManager, pageSize);
                }
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return INSTANCE;
            }
        }
        if (taskMemoryManager.getTungstenMemoryMode() != MemoryMode.OFF_HEAP) {
            throw new IllegalArgumentException("CometShuffleMemoryAllocator should be used with off-heap memory mode, but got " + taskMemoryManager.getTungstenMemoryMode());
        }
        return new CometShuffleMemoryAllocator(taskMemoryManager, pageSize);
    }

    CometShuffleMemoryAllocator(TaskMemoryManager taskMemoryManager, long pageSize) {
        super(taskMemoryManager, pageSize, MemoryMode.OFF_HEAP);
    }

    public long spill(long l, MemoryConsumer memoryConsumer) throws IOException {
        return 0L;
    }

    @Override
    public synchronized MemoryBlock allocate(long required) {
        return this.allocatePage(required);
    }

    @Override
    public synchronized void free(MemoryBlock block) {
        this.freePage(block);
    }

    @Override
    public long getOffsetInPage(long pagePlusOffsetAddress) {
        return this.taskMemoryManager.getOffsetInPage(pagePlusOffsetAddress);
    }

    public long encodePageNumberAndOffset(int pageNumber, long offsetInPage) {
        return TaskMemoryManager.encodePageNumberAndOffset((int)pageNumber, (long)offsetInPage);
    }

    @Override
    public long encodePageNumberAndOffset(MemoryBlock page, long offsetInPage) {
        return this.encodePageNumberAndOffset(page.pageNumber, offsetInPage - page.getBaseOffset());
    }
}

