/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.testing;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.comet.testing.DataGenOptions;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Double$;
import scala.Float$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class ParquetGenerator$ {
    public static ParquetGenerator$ MODULE$;
    private final Seq<DataType> primitiveTypes;

    static {
        new ParquetGenerator$();
    }

    private Seq<DataType> primitiveTypes() {
        return this.primitiveTypes;
    }

    public void makeParquetFile(Random r, SparkSession spark, String filename, int numRows, DataGenOptions options) {
        Object object;
        ListBuffer dataTypes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        dataTypes.appendAll(this.primitiveTypes());
        Object object2 = options.generateStruct() ? dataTypes.$plus$eq((Object)StructType$.MODULE$.apply((Seq)((TraversableLike)this.primitiveTypes().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> new StructField(new StringBuilder(1).append("c").append(x._2$mcI$sp()).toString(), (DataType)x._1(), true, StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom()))) : BoxedUnit.UNIT;
        Object object3 = options.generateMap() ? dataTypes.$plus$eq((Object)MapType$.MODULE$.apply(DataTypes.IntegerType, DataTypes.StringType)) : BoxedUnit.UNIT;
        if (options.generateArray()) {
            dataTypes.appendAll((TraversableOnce)this.primitiveTypes().map((Function1 & Serializable & scala.Serializable)x$1 -> DataTypes.createArrayType((DataType)x$1), Seq$.MODULE$.canBuildFrom()));
            Object object4 = options.generateStruct() ? dataTypes.$plus$eq((Object)DataTypes.createArrayType((DataType)StructType$.MODULE$.apply((Seq)((TraversableLike)this.primitiveTypes().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> new StructField(new StringBuilder(1).append("c").append(x._2$mcI$sp()).toString(), (DataType)x._1(), true, StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom())))) : BoxedUnit.UNIT;
            object = options.generateMap() ? dataTypes.$plus$eq((Object)DataTypes.createArrayType((DataType)MapType$.MODULE$.apply(DataTypes.IntegerType, DataTypes.StringType))) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Seq fields = ((ListBuffer)((TraversableLike)dataTypes.zipWithIndex(ListBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)i -> new StructField(new StringBuilder(1).append("c").append(i._2$mcI$sp()).toString(), (DataType)i._1(), true, StructField$.MODULE$.apply$default$4()), ListBuffer$.MODULE$.canBuildFrom())).toSeq();
        StructType schema = StructType$.MODULE$.apply(fields);
        Seq cols = ((SeqLike)fields.map((Function1 & Serializable & scala.Serializable)f -> MODULE$.generateColumn(r, f.dataType(), numRows, options), Seq$.MODULE$.canBuildFrom())).toSeq();
        IndexedSeq rows = (IndexedSeq)package$.MODULE$.Range().apply(0, numRows).map((Function1 & Serializable & scala.Serializable)rowIndex -> Row$.MODULE$.fromSeq((Seq)cols.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.apply(rowIndex), Seq$.MODULE$.canBuildFrom())), IndexedSeq$.MODULE$.canBuildFrom());
        Dataset df = spark.createDataFrame(spark.sparkContext().parallelize((Seq)rows, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), schema);
        df.write().mode(SaveMode.Overwrite).parquet(filename);
    }

    public Seq<Object> generateColumn(Random r, DataType dataType, int numRows, DataGenOptions options) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            Seq<Object> values = this.generateColumn(r, elementType, numRows, options);
            ListBuffer list = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach((Function1 & Serializable & scala.Serializable)i -> ParquetGenerator$.$anonfun$generateColumn$1(options, list, r, values, BoxesRunTime.unboxToInt((Object)i)));
            return list.toSeq();
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            Seq[] values = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)f -> MODULE$.generateColumn(r, f.dataType(), numRows, options), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
            return (Seq)package$.MODULE$.Range().apply(0, numRows).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).indices().map((Function1 & Serializable & scala.Serializable)j -> ParquetGenerator$.$anonfun$generateColumn$5(values$2, i, BoxesRunTime.unboxToInt((Object)j)), IndexedSeq$.MODULE$.canBuildFrom())), IndexedSeq$.MODULE$.canBuildFrom());
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            DataGenOptions mapOptions = options.copy(false, options.copy$default$2(), options.copy$default$3(), options.copy$default$4(), options.copy$default$5());
            Seq<Object> k = this.generateColumn(r, keyType, numRows, mapOptions);
            Seq<Object> v = this.generateColumn(r, valueType, numRows, mapOptions);
            return (Seq)((TraversableLike)k.zip(v, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._1()), x._2())})), Seq$.MODULE$.canBuildFrom());
        }
        DataType dataType3 = DataTypes.BooleanType;
        DataType dataType4 = dataType2;
        if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
            return (Seq)((TraversableLike)this.generateColumn(r, DataTypes.LongType, numRows, options).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToShort((short)ParquetGenerator$.$anonfun$generateColumn$7(x$2)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ParquetGenerator$.$anonfun$generateColumn$8(BoxesRunTime.unboxToShort((Object)s))), Seq$.MODULE$.canBuildFrom());
        }
        DataType dataType5 = DataTypes.ByteType;
        DataType dataType6 = dataType2;
        if (!(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null)) {
            return (Seq)this.generateColumn(r, DataTypes.LongType, numRows, options).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToByte((byte)ParquetGenerator$.$anonfun$generateColumn$9(x$3)), Seq$.MODULE$.canBuildFrom());
        }
        DataType dataType7 = DataTypes.ShortType;
        DataType dataType8 = dataType2;
        if (!(dataType7 != null ? !dataType7.equals(dataType8) : dataType8 != null)) {
            return (Seq)this.generateColumn(r, DataTypes.LongType, numRows, options).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToShort((short)ParquetGenerator$.$anonfun$generateColumn$10(x$4)), Seq$.MODULE$.canBuildFrom());
        }
        DataType dataType9 = DataTypes.IntegerType;
        DataType dataType10 = dataType2;
        if (!(dataType9 != null ? !dataType9.equals(dataType10) : dataType10 != null)) {
            return (Seq)this.generateColumn(r, DataTypes.LongType, numRows, options).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ParquetGenerator$.$anonfun$generateColumn$11(x$5)), Seq$.MODULE$.canBuildFrom());
        }
        DataType dataType11 = DataTypes.LongType;
        DataType dataType12 = dataType2;
        if (!(dataType11 != null ? !dataType11.equals(dataType12) : dataType12 != null)) {
            return (Seq)package$.MODULE$.Range().apply(0, numRows).map((Function1 & Serializable & scala.Serializable)x$6 -> ParquetGenerator$.$anonfun$generateColumn$12(r, options, BoxesRunTime.unboxToInt((Object)x$6)), IndexedSeq$.MODULE$.canBuildFrom());
        }
        DataType dataType13 = DataTypes.FloatType;
        DataType dataType14 = dataType2;
        if (!(dataType13 != null ? !dataType13.equals(dataType14) : dataType14 != null)) {
            return (Seq)package$.MODULE$.Range().apply(0, numRows).map((Function1 & Serializable & scala.Serializable)x$7 -> ParquetGenerator$.$anonfun$generateColumn$13(r, options, BoxesRunTime.unboxToInt((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom());
        }
        DataType dataType15 = DataTypes.DoubleType;
        DataType dataType16 = dataType2;
        if (!(dataType15 != null ? !dataType15.equals(dataType16) : dataType16 != null)) {
            return (Seq)package$.MODULE$.Range().apply(0, numRows).map((Function1 & Serializable & scala.Serializable)x$8 -> ParquetGenerator$.$anonfun$generateColumn$14(r, options, BoxesRunTime.unboxToInt((Object)x$8)), IndexedSeq$.MODULE$.canBuildFrom());
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return (Seq)package$.MODULE$.Range().apply(0, numRows).map((Function1 & Serializable & scala.Serializable)x$9 -> ParquetGenerator$.$anonfun$generateColumn$15(r, decimalType, BoxesRunTime.unboxToInt((Object)x$9)), IndexedSeq$.MODULE$.canBuildFrom());
        }
        DataType dataType17 = DataTypes.StringType;
        DataType dataType18 = dataType2;
        if (!(dataType17 != null ? !dataType17.equals(dataType18) : dataType18 != null)) {
            return (Seq)package$.MODULE$.Range().apply(0, numRows).map((Function1 & Serializable & scala.Serializable)x$10 -> ParquetGenerator$.$anonfun$generateColumn$16(r, options, BoxesRunTime.unboxToInt((Object)x$10)), IndexedSeq$.MODULE$.canBuildFrom());
        }
        DataType dataType19 = DataTypes.BinaryType;
        DataType dataType20 = dataType2;
        if (!(dataType19 != null ? !dataType19.equals(dataType20) : dataType20 != null)) {
            return (Seq)this.generateColumn(r, DataTypes.StringType, numRows, options).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Object object = x0$1;
                if (object instanceof String) {
                    String string = (String)object;
                    return string.getBytes(Charset.defaultCharset());
                }
                return null;
            }, Seq$.MODULE$.canBuildFrom());
        }
        DataType dataType21 = DataTypes.DateType;
        DataType dataType22 = dataType2;
        if (!(dataType21 != null ? !dataType21.equals(dataType22) : dataType22 != null)) {
            return (Seq)package$.MODULE$.Range().apply(0, numRows).map((Function1 & Serializable & scala.Serializable)x$11 -> ParquetGenerator$.$anonfun$generateColumn$18(r, BoxesRunTime.unboxToInt((Object)x$11)), IndexedSeq$.MODULE$.canBuildFrom());
        }
        DataType dataType23 = DataTypes.TimestampType;
        DataType dataType24 = dataType2;
        if (!(dataType23 != null ? !dataType23.equals(dataType24) : dataType24 != null)) {
            return (Seq)package$.MODULE$.Range().apply(0, numRows).map((Function1 & Serializable & scala.Serializable)x$12 -> ParquetGenerator$.$anonfun$generateColumn$19(r, BoxesRunTime.unboxToInt((Object)x$12)), IndexedSeq$.MODULE$.canBuildFrom());
        }
        throw new IllegalStateException(new StringBuilder(29).append("Cannot generate data for ").append(dataType).append(" yet").toString());
    }

    public static final /* synthetic */ ListBuffer $anonfun$generateColumn$1(DataGenOptions options$2, ListBuffer list$1, Random r$2, Seq values$1, int i) {
        if (i % 10 == 0 && options$2.allowNull()) {
            return list$1.$plus$eq(null);
        }
        return list$1.$plus$eq(((TraversableOnce)package$.MODULE$.Range().apply(0, r$2.nextInt(5)).map((Function1 & Serializable & scala.Serializable)j -> values$1.apply((i + BoxesRunTime.unboxToInt((Object)j)) % values$1.length()), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any()));
    }

    public static final /* synthetic */ Object $anonfun$generateColumn$5(Seq[] values$2, int i$2, int j) {
        return values$2[j].apply(i$2);
    }

    public static final /* synthetic */ short $anonfun$generateColumn$7(Object x$2) {
        return (short)BoxesRunTime.unboxToLong((Object)x$2);
    }

    public static final /* synthetic */ boolean $anonfun$generateColumn$8(short s) {
        return s % 2 == 0;
    }

    public static final /* synthetic */ byte $anonfun$generateColumn$9(Object x$3) {
        return (byte)BoxesRunTime.unboxToLong((Object)x$3);
    }

    public static final /* synthetic */ short $anonfun$generateColumn$10(Object x$4) {
        return (short)BoxesRunTime.unboxToLong((Object)x$4);
    }

    public static final /* synthetic */ int $anonfun$generateColumn$11(Object x$5) {
        return (int)BoxesRunTime.unboxToLong((Object)x$5);
    }

    public static final /* synthetic */ Object $anonfun$generateColumn$12(Random r$2, DataGenOptions options$2, int x$6) {
        int n = r$2.nextInt(50);
        switch (n) {
            case 0: {
                if (!options$2.allowNull()) break;
                return null;
            }
            case 1: {
                return BoxesRunTime.boxToLong((long)0L);
            }
            case 2: {
                return BoxesRunTime.boxToLong((long)-128);
            }
            case 3: {
                return BoxesRunTime.boxToLong((long)127);
            }
            case 4: {
                return BoxesRunTime.boxToLong((long)Short.MIN_VALUE);
            }
            case 5: {
                return BoxesRunTime.boxToLong((long)Short.MAX_VALUE);
            }
            case 6: {
                return BoxesRunTime.boxToLong((long)Integer.MIN_VALUE);
            }
            case 7: {
                return BoxesRunTime.boxToLong((long)Integer.MAX_VALUE);
            }
            case 8: {
                return BoxesRunTime.boxToLong((long)Long.MIN_VALUE);
            }
            case 9: {
                return BoxesRunTime.boxToLong((long)Long.MAX_VALUE);
            }
        }
        return BoxesRunTime.boxToLong((long)r$2.nextLong());
    }

    public static final /* synthetic */ Object $anonfun$generateColumn$13(Random r$2, DataGenOptions options$2, int x$7) {
        int n = r$2.nextInt(20);
        switch (n) {
            case 0: {
                if (!options$2.allowNull()) break;
                return null;
            }
            case 1: {
                return BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY);
            }
            case 2: {
                return BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY);
            }
            case 3: {
                return BoxesRunTime.boxToFloat((float)Float$.MODULE$.MinValue());
            }
            case 4: {
                return BoxesRunTime.boxToFloat((float)Float.MAX_VALUE);
            }
            case 5: {
                return BoxesRunTime.boxToFloat((float)0.0f);
            }
            case 6: {
                if (!options$2.generateNegativeZero()) break;
                return BoxesRunTime.boxToFloat((float)-0.0f);
            }
        }
        return BoxesRunTime.boxToFloat((float)r$2.nextFloat());
    }

    public static final /* synthetic */ Object $anonfun$generateColumn$14(Random r$2, DataGenOptions options$2, int x$8) {
        int n = r$2.nextInt(20);
        switch (n) {
            case 0: {
                if (!options$2.allowNull()) break;
                return null;
            }
            case 1: {
                return BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY);
            }
            case 2: {
                return BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY);
            }
            case 3: {
                return BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue());
            }
            case 4: {
                return BoxesRunTime.boxToDouble((double)Double.MAX_VALUE);
            }
            case 5: {
                return BoxesRunTime.boxToDouble((double)0.0);
            }
            case 6: {
                if (!options$2.generateNegativeZero()) break;
                return BoxesRunTime.boxToDouble((double)-0.0);
            }
        }
        return BoxesRunTime.boxToDouble((double)r$2.nextDouble());
    }

    public static final /* synthetic */ BigDecimal $anonfun$generateColumn$15(Random r$2, DecimalType x14$1, int x$9) {
        return new BigDecimal(r$2.nextDouble()).setScale(x14$1.scale(), RoundingMode.HALF_UP);
    }

    public static final /* synthetic */ String $anonfun$generateColumn$16(Random r$2, DataGenOptions options$2, int x$10) {
        int n = r$2.nextInt(10);
        switch (n) {
            case 0: {
                if (!options$2.allowNull()) break;
                return null;
            }
            case 1: {
                return Byte.toString((byte)r$2.nextInt());
            }
            case 2: {
                return Long.toString(r$2.nextLong());
            }
            case 3: {
                return Double.toString(r$2.nextDouble());
            }
        }
        return r$2.nextString(8);
    }

    public static final /* synthetic */ Date $anonfun$generateColumn$18(Random r$2, int x$11) {
        return new Date(1716645600011L + (long)r$2.nextInt());
    }

    public static final /* synthetic */ Timestamp $anonfun$generateColumn$19(Random r$2, int x$12) {
        return new Timestamp(1716645600011L + (long)r$2.nextInt());
    }

    private ParquetGenerator$() {
        MODULE$ = this;
        this.primitiveTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{DataTypes.BooleanType, DataTypes.ByteType, DataTypes.ShortType, DataTypes.IntegerType, DataTypes.LongType, DataTypes.FloatType, DataTypes.DoubleType, DataTypes.createDecimalType((int)10, (int)2), DataTypes.createDecimalType((int)36, (int)18), DataTypes.DateType, DataTypes.TimestampType, DataTypes.StringType, DataTypes.BinaryType}));
    }
}

