/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.vector.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.comet.shaded.arrow.vector.util.IntObjectHashMap;
import org.apache.comet.shaded.arrow.vector.util.MapWithOrdinal;

public class MultiMapWithOrdinal<K, V>
implements MapWithOrdinal<K, V> {
    private final Map<K, Set<Integer>> keyToOrdinal = new LinkedHashMap<K, Set<Integer>>();
    private final IntObjectHashMap<V> ordinalToValue = new IntObjectHashMap();

    @Override
    public V getByOrdinal(int id) {
        return this.ordinalToValue.get(id);
    }

    @Override
    public int getOrdinal(K key) {
        Set<Integer> pair = this.getOrdinals(key);
        if (!pair.isEmpty()) {
            return pair.iterator().next();
        }
        return -1;
    }

    private Set<Integer> getOrdinals(K key) {
        return this.keyToOrdinal.getOrDefault(key, new HashSet());
    }

    @Override
    public int size() {
        return this.ordinalToValue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ordinalToValue.isEmpty();
    }

    @Override
    public V get(K key) {
        Set<Integer> ordinals = this.keyToOrdinal.get(key);
        if (ordinals == null) {
            return null;
        }
        return (V)ordinals.stream().map(this.ordinalToValue::get).collect(Collectors.toList()).get(0);
    }

    @Override
    public Collection<V> getAll(K key) {
        Set<Integer> ordinals = this.keyToOrdinal.get(key);
        if (ordinals == null) {
            return null;
        }
        return ordinals.stream().map(this.ordinalToValue::get).collect(Collectors.toList());
    }

    @Override
    public boolean put(K key, V value, boolean overwrite) {
        if (overwrite) {
            this.removeAll(key);
        }
        Set<Integer> ordinalSet = this.getOrdinals(key);
        int nextOrdinal = this.ordinalToValue.size();
        this.ordinalToValue.put(nextOrdinal, value);
        boolean changed = ordinalSet.add(nextOrdinal);
        this.keyToOrdinal.put(key, ordinalSet);
        return changed;
    }

    @Override
    public Collection<V> values() {
        return this.ordinalToValue.values();
    }

    @Override
    public boolean containsKey(K key) {
        return this.keyToOrdinal.containsKey(key);
    }

    @Override
    public synchronized boolean remove(K key, V value) {
        Set<Integer> removalSet = this.getOrdinals(key);
        if (removalSet.isEmpty()) {
            return false;
        }
        Optional<Object> removeValue = removalSet.stream().map(this.ordinalToValue::get).filter(value::equals).findFirst();
        if (!removeValue.isPresent()) {
            return false;
        }
        int removalOrdinal = this.removeKv(removalSet, key, value);
        int lastOrdinal = this.ordinalToValue.size();
        if (lastOrdinal != removalOrdinal) {
            this.swapOrdinal(lastOrdinal, removalOrdinal);
        }
        return true;
    }

    private void swapOrdinal(int lastOrdinal, int removalOrdinal) {
        V swapOrdinalValue = this.ordinalToValue.remove(lastOrdinal);
        this.ordinalToValue.put(removalOrdinal, swapOrdinalValue);
        Object swapOrdinalKey = this.keyToOrdinal.entrySet().stream().filter(kv -> ((Set)kv.getValue()).stream().anyMatch(o -> o == lastOrdinal)).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new IllegalStateException("MultimapWithOrdinal in bad state"));
        this.ordinalToValue.put(removalOrdinal, swapOrdinalValue);
        Set<Integer> swapSet = this.getOrdinals(swapOrdinalKey);
        swapSet.remove(lastOrdinal);
        swapSet.add(removalOrdinal);
        this.keyToOrdinal.put(swapOrdinalKey, swapSet);
    }

    private int removeKv(Set<Integer> removalSet, K key, V value) {
        Integer removalOrdinal = removalSet.stream().filter(i -> this.ordinalToValue.get(i).equals(value)).findFirst().orElseThrow(() -> new IllegalStateException("MultimapWithOrdinal in bad state"));
        this.ordinalToValue.remove(removalOrdinal);
        removalSet.remove(removalOrdinal);
        if (removalSet.isEmpty()) {
            this.keyToOrdinal.remove(key);
        } else {
            this.keyToOrdinal.put(key, removalSet);
        }
        return removalOrdinal;
    }

    @Override
    public synchronized boolean removeAll(K key) {
        Collection<V> values = this.getAll(key);
        if (values == null) {
            return false;
        }
        for (V v : values) {
            this.remove(key, v);
        }
        return true;
    }

    @Override
    public void clear() {
        this.ordinalToValue.clear();
        this.keyToOrdinal.clear();
    }

    @Override
    public Set<K> keys() {
        return this.keyToOrdinal.keySet();
    }
}

