/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.comet.util;

import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import org.apache.comet.shaded.arrow.c.CDataDictionaryProvider;
import org.apache.comet.shaded.arrow.vector.BigIntVector;
import org.apache.comet.shaded.arrow.vector.BitVector;
import org.apache.comet.shaded.arrow.vector.DateDayVector;
import org.apache.comet.shaded.arrow.vector.DecimalVector;
import org.apache.comet.shaded.arrow.vector.FieldVector;
import org.apache.comet.shaded.arrow.vector.FixedSizeBinaryVector;
import org.apache.comet.shaded.arrow.vector.Float4Vector;
import org.apache.comet.shaded.arrow.vector.Float8Vector;
import org.apache.comet.shaded.arrow.vector.IntVector;
import org.apache.comet.shaded.arrow.vector.SmallIntVector;
import org.apache.comet.shaded.arrow.vector.TimeStampMicroTZVector;
import org.apache.comet.shaded.arrow.vector.TimeStampMicroVector;
import org.apache.comet.shaded.arrow.vector.TinyIntVector;
import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.shaded.arrow.vector.VarBinaryVector;
import org.apache.comet.shaded.arrow.vector.VarCharVector;
import org.apache.comet.shaded.arrow.vector.VectorSchemaRoot;
import org.apache.comet.shaded.arrow.vector.complex.StructVector;
import org.apache.comet.shaded.arrow.vector.dictionary.DictionaryProvider;
import org.apache.comet.shaded.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.comet.shaded.arrow.vector.types.DateUnit;
import org.apache.comet.shaded.arrow.vector.types.FloatingPointPrecision;
import org.apache.comet.shaded.arrow.vector.types.IntervalUnit;
import org.apache.comet.shaded.arrow.vector.types.TimeUnit;
import org.apache.comet.shaded.arrow.vector.types.pojo.ArrowType;
import org.apache.comet.shaded.arrow.vector.types.pojo.Field;
import org.apache.comet.shaded.arrow.vector.types.pojo.FieldType;
import org.apache.comet.shaded.arrow.vector.types.pojo.Schema;
import org.apache.comet.vector.CometVector;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.apache.spark.util.io.ChunkedByteBufferOutputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.sys.package$;

public final class Utils$ {
    public static Utils$ MODULE$;

    static {
        new Utils$();
    }

    public String getConfPath(String confFileName) {
        return (String)package$.MODULE$.env().get((Object)"COMET_CONF_DIR").map((Function1 & Serializable & scala.Serializable)t -> new File(new StringBuilder(0).append((String)t).append(File.separator).append(confFileName).toString())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFile())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getAbsolutePath()).orNull(Predef$.MODULE$.$conforms());
    }

    public Seq<String> stringToSeq(String str) {
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])str.split(","))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$stringToSeq$2(x$4))));
    }

    public String getSimpleName(Class<?> cls) {
        return org.apache.spark.util.Utils$.MODULE$.getSimpleName(cls);
    }

    public DataType fromArrowField(Field field) {
        ArrowType arrowType = field.getType();
        if (arrowType instanceof ArrowType.Map) {
            Field elementField = field.getChildren().get(0);
            DataType keyType = this.fromArrowField(elementField.getChildren().get(0));
            DataType valueType = this.fromArrowField(elementField.getChildren().get(1));
            return new MapType(keyType, valueType, elementField.getChildren().get(1).isNullable());
        }
        ArrowType.List list = ArrowType.List.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(list != null ? !((Object)list).equals(arrowType2) : arrowType2 != null)) {
            Field elementField = field.getChildren().get(0);
            DataType elementType = this.fromArrowField(elementField);
            return new ArrayType(elementType, elementField.isNullable());
        }
        ArrowType.Struct struct = ArrowType.Struct.INSTANCE;
        ArrowType arrowType3 = arrowType;
        if (!(struct != null ? !((Object)struct).equals(arrowType3) : arrowType3 != null)) {
            Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(field.getChildren()).asScala()).map((Function1 & Serializable & scala.Serializable)child -> {
                DataType dt = MODULE$.fromArrowField((Field)child);
                return new StructField(child.getName(), dt, child.isNullable(), StructField$.MODULE$.apply$default$4());
            }, Buffer$.MODULE$.canBuildFrom());
            return StructType$.MODULE$.apply(fields.toSeq());
        }
        return this.fromArrowType(arrowType);
    }

    public DataType fromArrowType(ArrowType dt) {
        boolean bl = false;
        ArrowType.Int intVal = null;
        boolean bl2 = false;
        ArrowType.FloatingPoint floatingPoint = null;
        boolean bl3 = false;
        ArrowType.Timestamp timestamp = null;
        boolean bl4 = false;
        ArrowType.Interval interval = null;
        ArrowType arrowType = dt;
        ArrowType.Bool bool = ArrowType.Bool.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(bool != null ? !((Object)bool).equals(arrowType2) : arrowType2 != null)) {
            return BooleanType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Int) {
            bl = true;
            intVal = (ArrowType.Int)arrowType;
            if (intVal.getIsSigned() && intVal.getBitWidth() == 8) {
                return ByteType$.MODULE$;
            }
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 16) {
            return ShortType$.MODULE$;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 32) {
            return IntegerType$.MODULE$;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 64) {
            return LongType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.FloatingPoint) {
            bl2 = true;
            floatingPoint = (ArrowType.FloatingPoint)arrowType;
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.SINGLE;
            if (!(floatingPointPrecision != null ? !((Object)((Object)floatingPointPrecision)).equals((Object)floatingPointPrecision2) : floatingPointPrecision2 != null)) {
                return FloatType$.MODULE$;
            }
        }
        if (bl2) {
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision3 = FloatingPointPrecision.DOUBLE;
            if (!(floatingPointPrecision != null ? !((Object)((Object)floatingPointPrecision)).equals((Object)floatingPointPrecision3) : floatingPointPrecision3 != null)) {
                return DoubleType$.MODULE$;
            }
        }
        ArrowType.Utf8 utf8 = ArrowType.Utf8.INSTANCE;
        ArrowType arrowType3 = arrowType;
        if (!(utf8 != null ? !((Object)utf8).equals(arrowType3) : arrowType3 != null)) {
            return StringType$.MODULE$;
        }
        ArrowType.Binary binary = ArrowType.Binary.INSTANCE;
        ArrowType arrowType4 = arrowType;
        if (!(binary != null ? !((Object)binary).equals(arrowType4) : arrowType4 != null)) {
            return BinaryType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.FixedSizeBinary) {
            return BinaryType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Decimal) {
            ArrowType.Decimal decimal = (ArrowType.Decimal)arrowType;
            return new DecimalType(decimal.getPrecision(), decimal.getScale());
        }
        if (arrowType instanceof ArrowType.Date) {
            ArrowType.Date date = (ArrowType.Date)arrowType;
            DateUnit dateUnit = date.getUnit();
            DateUnit dateUnit2 = DateUnit.DAY;
            if (!(dateUnit != null ? !((Object)((Object)dateUnit)).equals((Object)dateUnit2) : dateUnit2 != null)) {
                return DateType$.MODULE$;
            }
        }
        if (arrowType instanceof ArrowType.Timestamp) {
            bl3 = true;
            timestamp = (ArrowType.Timestamp)arrowType;
            TimeUnit timeUnit = timestamp.getUnit();
            TimeUnit timeUnit2 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !((Object)((Object)timeUnit)).equals((Object)timeUnit2) : timeUnit2 != null) && timestamp.getTimezone() == null) {
                return TimestampNTZType$.MODULE$;
            }
        }
        if (bl3) {
            TimeUnit timeUnit = timestamp.getUnit();
            TimeUnit timeUnit3 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !((Object)((Object)timeUnit)).equals((Object)timeUnit3) : timeUnit3 != null)) {
                return TimestampType$.MODULE$;
            }
        }
        ArrowType.Null nullVal = ArrowType.Null.INSTANCE;
        ArrowType arrowType5 = arrowType;
        if (!(nullVal != null ? !((Object)nullVal).equals(arrowType5) : arrowType5 != null)) {
            return NullType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Interval) {
            bl4 = true;
            interval = (ArrowType.Interval)arrowType;
            IntervalUnit intervalUnit = interval.getUnit();
            IntervalUnit intervalUnit2 = IntervalUnit.YEAR_MONTH;
            if (!(intervalUnit != null ? !((Object)((Object)intervalUnit)).equals((Object)intervalUnit2) : intervalUnit2 != null)) {
                return YearMonthIntervalType$.MODULE$.apply();
            }
        }
        if (bl4) {
            IntervalUnit intervalUnit = interval.getUnit();
            IntervalUnit intervalUnit3 = IntervalUnit.DAY_TIME;
            if (!(intervalUnit != null ? !((Object)((Object)intervalUnit)).equals((Object)intervalUnit3) : intervalUnit3 != null)) {
                return DayTimeIntervalType$.MODULE$.apply();
            }
        }
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dt.toString()).toString());
    }

    public StructType fromArrowSchema(Schema schema) {
        return new StructType((StructField[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> {
            DataType dt = MODULE$.fromArrowField((Field)field);
            return new StructField(field.getName(), dt, field.isNullable(), StructField$.MODULE$.apply$default$4());
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public ArrowType toArrowType(DataType dt, String timeZoneId) {
        DecimalType decimalType;
        Option option;
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return ArrowType.Bool.INSTANCE;
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return new ArrowType.Int(8, true);
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return new ArrowType.Int(16, true);
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return new ArrowType.Int(32, true);
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return new ArrowType.Int(64, true);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return ArrowType.Utf8.INSTANCE;
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return ArrowType.Binary.INSTANCE;
        }
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return new ArrowType.Decimal(precision, scale, 128);
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return new ArrowType.Date(DateUnit.DAY);
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            if (timeZoneId == null) {
                throw new UnsupportedOperationException(new StringBuilder(33).append(TimestampType$.MODULE$.catalogString()).append(" must supply timeZoneId parameter").toString());
            }
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, timeZoneId);
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, null);
        }
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dt.catalogString()).toString());
    }

    public Field toArrowField(String name, DataType dt, boolean nullable, String timeZoneId) {
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            FieldType fieldType = new FieldType(nullable, ArrowType.List.INSTANCE, null);
            return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("element", elementType, containsNull, timeZoneId), (List)Nil$.MODULE$)).asJava());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            FieldType fieldType = new FieldType(nullable, ArrowType.Struct.INSTANCE, null);
            return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class))))).toSeq()).asJava());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            FieldType mapType2 = new FieldType(nullable, new ArrowType.Map(false), null);
            return new Field(name, mapType2, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("entries", (DataType)new StructType().add("key", keyType, false).add("value", valueType, valueContainsNull), false, timeZoneId), (List)Nil$.MODULE$)).asJava());
        }
        FieldType fieldType = new FieldType(nullable, this.toArrowType(dataType, timeZoneId), null);
        return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
    }

    public Schema toArrowSchema(StructType schema, String timeZoneId) {
        return new Schema((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema.map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId), Seq$.MODULE$.canBuildFrom())).asJava());
    }

    public Iterator<Tuple2<Object, ChunkedByteBuffer>> serializeBatches(Iterator<ColumnarBatch> batches) {
        return batches.map((Function1 & Serializable & scala.Serializable)batch -> {
            CDataDictionaryProvider dictionaryProvider = new CDataDictionaryProvider();
            CompressionCodec codec = CompressionCodec$.MODULE$.createCodec(SparkEnv$.MODULE$.get().conf());
            ChunkedByteBufferOutputStream cbbos = new ChunkedByteBufferOutputStream(0x100000, (Function1 & Serializable & scala.Serializable)x$1 -> Utils$.$anonfun$serializeBatches$2(BoxesRunTime.unboxToInt((Object)x$1)));
            DataOutputStream out = new DataOutputStream(codec.compressedOutputStream((OutputStream)cbbos));
            Tuple2<Seq<FieldVector>, Option<DictionaryProvider>> tuple2 = MODULE$.getBatchFieldVectors((ColumnarBatch)batch);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq fieldVectors = (Seq)tuple2._1();
            Option batchProviderOpt = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)fieldVectors, (Object)batchProviderOpt);
            Seq fieldVectors2 = (Seq)tuple22._1();
            Option batchProviderOpt2 = (Option)tuple22._2();
            VectorSchemaRoot root = new VectorSchemaRoot((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(fieldVectors2).asJava());
            DictionaryProvider provider = (DictionaryProvider)batchProviderOpt2.getOrElse((Function0 & Serializable & scala.Serializable)() -> dictionaryProvider);
            ArrowStreamWriter writer = new ArrowStreamWriter(root, provider, Channels.newChannel(out));
            writer.start();
            writer.writeBatch();
            root.clear();
            writer.close();
            if (out.size() > 0) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)batch.numRows()), (Object)cbbos.toChunkedByteBuffer());
            }
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)batch.numRows()), (Object)new ChunkedByteBuffer((ByteBuffer[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ByteBuffer.class))));
        });
    }

    public Tuple2<Seq<FieldVector>, Option<DictionaryProvider>> getBatchFieldVectors(ColumnarBatch batch) {
        ObjectRef provider = ObjectRef.create((Object)None$.MODULE$);
        IndexedSeq fieldVectors = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batch.numCols()).map((Function1 & Serializable & scala.Serializable)index -> Utils$.$anonfun$getBatchFieldVectors$1(batch, provider, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)fieldVectors, (Object)((Option)provider.elem));
    }

    public FieldVector getFieldVector(ValueVector valueVector, String reason) {
        ValueVector valueVector2 = valueVector;
        if (valueVector2 instanceof BitVector ? true : (valueVector2 instanceof TinyIntVector ? true : (valueVector2 instanceof SmallIntVector ? true : (valueVector2 instanceof IntVector ? true : (valueVector2 instanceof BigIntVector ? true : (valueVector2 instanceof Float4Vector ? true : (valueVector2 instanceof Float8Vector ? true : (valueVector2 instanceof VarCharVector ? true : (valueVector2 instanceof DecimalVector ? true : (valueVector2 instanceof DateDayVector ? true : (valueVector2 instanceof TimeStampMicroTZVector ? true : (valueVector2 instanceof VarBinaryVector ? true : (valueVector2 instanceof FixedSizeBinaryVector ? true : (valueVector2 instanceof TimeStampMicroVector ? true : valueVector2 instanceof StructVector)))))))))))))) {
            return (FieldVector)valueVector2;
        }
        throw new SparkException(new StringBuilder(31).append("Unsupported Arrow Vector for ").append(reason).append(": ").append(valueVector.getClass()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$stringToSeq$2(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public static final /* synthetic */ ByteBuffer $anonfun$serializeBatches$2(int x$1) {
        return ByteBuffer.allocate(x$1);
    }

    public static final /* synthetic */ FieldVector $anonfun$getBatchFieldVectors$1(ColumnarBatch batch$1, ObjectRef provider$1, int index) {
        ColumnVector columnVector = batch$1.column(index);
        if (columnVector instanceof CometVector) {
            CometVector cometVector = (CometVector)columnVector;
            ValueVector valueVector = cometVector.getValueVector();
            if (valueVector.getField().getDictionary() != null && ((Option)provider$1.elem).isEmpty()) {
                provider$1.elem = new Some((Object)cometVector.getDictionaryProvider());
            }
            return MODULE$.getFieldVector(valueVector, "serialize");
        }
        throw new SparkException(new StringBuilder(49).append("Comet execution only takes Arrow Arrays, but got ").append(columnVector.getClass()).toString());
    }

    private Utils$() {
        MODULE$ = this;
    }
}

