/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.comet;

import java.io.IOException;
import java.util.BitSet;
import org.apache.comet.CometSparkSessionExtensions$;
import org.apache.spark.SparkConf;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.SparkOutOfMemoryError;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.shuffle.comet.TooLargePageException;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.unsafe.memory.UnsafeMemoryAllocator;

public final class CometShuffleMemoryAllocator
extends MemoryConsumer {
    private final UnsafeMemoryAllocator allocator = new UnsafeMemoryAllocator();
    private final long pageSize;
    private final long totalMemory;
    private long allocatedMemory = 0L;
    private static final int PAGE_NUMBER_BITS = 13;
    private static final int PAGE_TABLE_SIZE = 8192;
    private final MemoryBlock[] pageTable = new MemoryBlock[8192];
    private final BitSet allocatedPages = new BitSet(8192);
    private static final int OFFSET_BITS = 51;
    private static final long MASK_LONG_LOWER_51_BITS = 0x7FFFFFFFFFFFFL;
    private static CometShuffleMemoryAllocator INSTANCE;

    public static synchronized CometShuffleMemoryAllocator getInstance(SparkConf conf, TaskMemoryManager taskMemoryManager, long pageSize) {
        if (INSTANCE == null) {
            INSTANCE = new CometShuffleMemoryAllocator(conf, taskMemoryManager, pageSize);
        }
        return INSTANCE;
    }

    CometShuffleMemoryAllocator(SparkConf conf, TaskMemoryManager taskMemoryManager, long pageSize) {
        super(taskMemoryManager, pageSize, MemoryMode.OFF_HEAP);
        this.pageSize = pageSize;
        this.totalMemory = CometSparkSessionExtensions$.MODULE$.getCometShuffleMemorySize(conf, SQLConf.get());
    }

    public synchronized long acquireMemory(long size) {
        if (this.allocatedMemory >= this.totalMemory) {
            throw new SparkOutOfMemoryError("Unable to acquire " + size + " bytes of memory, current usage is " + this.allocatedMemory + " bytes and max memory is " + this.totalMemory + " bytes");
        }
        long allocationSize = Math.min(size, this.totalMemory - this.allocatedMemory);
        this.allocatedMemory += allocationSize;
        return allocationSize;
    }

    public long spill(long l, MemoryConsumer memoryConsumer) throws IOException {
        return 0L;
    }

    public synchronized LongArray allocateArray(long size) {
        long required = size * 8L;
        MemoryBlock page = this.allocate(required);
        return new LongArray(page);
    }

    public synchronized void freeArray(LongArray array) {
        if (array == null) {
            return;
        }
        this.free(array.memoryBlock());
    }

    public synchronized MemoryBlock allocatePage(long required) {
        long size = Math.max(this.pageSize, required);
        return this.allocate(size);
    }

    private synchronized MemoryBlock allocate(long required) {
        if (required > 0x3FFFFFFF8L) {
            throw new TooLargePageException(required);
        }
        long got = this.acquireMemory(required);
        if (got < required) {
            this.allocatedMemory -= got;
            throw new SparkOutOfMemoryError("Unable to acquire " + required + " bytes of memory, got " + got + " bytes. Available: " + (this.totalMemory - this.allocatedMemory));
        }
        int pageNumber = this.allocatedPages.nextClearBit(0);
        if (pageNumber >= 8192) {
            this.allocatedMemory -= got;
            throw new IllegalStateException("Have already allocated a maximum of 8192 pages");
        }
        MemoryBlock block = this.allocator.allocate(got);
        block.pageNumber = pageNumber;
        this.pageTable[pageNumber] = block;
        this.allocatedPages.set(pageNumber);
        return block;
    }

    public synchronized void free(MemoryBlock block) {
        if (block.pageNumber == -3) {
            return;
        }
        this.allocatedMemory -= block.size();
        this.pageTable[block.pageNumber] = null;
        this.allocatedPages.clear(block.pageNumber);
        block.pageNumber = -2;
        this.allocator.free(block);
    }

    public synchronized long getAvailableMemory() {
        return this.totalMemory - this.allocatedMemory;
    }

    public long getOffsetInPage(long pagePlusOffsetAddress) {
        long offsetInPage = this.decodeOffset(pagePlusOffsetAddress);
        int pageNumber = TaskMemoryManager.decodePageNumber((long)pagePlusOffsetAddress);
        assert (pageNumber >= 0 && pageNumber < 8192);
        MemoryBlock page = this.pageTable[pageNumber];
        assert (page != null);
        return page.getBaseOffset() + offsetInPage;
    }

    public long decodeOffset(long pagePlusOffsetAddress) {
        return pagePlusOffsetAddress & 0x7FFFFFFFFFFFFL;
    }

    public long encodePageNumberAndOffset(int pageNumber, long offsetInPage) {
        assert (pageNumber >= 0);
        return (long)pageNumber << 51 | offsetInPage & 0x7FFFFFFFFFFFFL;
    }

    public long encodePageNumberAndOffset(MemoryBlock page, long offsetInPage) {
        return this.encodePageNumberAndOffset(page.pageNumber, offsetInPage - page.getBaseOffset());
    }
}

