/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.vector;

import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.shaded.arrow.vector.complex.MapVector;
import org.apache.comet.shaded.arrow.vector.complex.StructVector;
import org.apache.comet.shaded.arrow.vector.dictionary.DictionaryProvider;
import org.apache.comet.shaded.arrow.vector.util.TransferPair;
import org.apache.comet.vector.CometDecodedVector;
import org.apache.comet.vector.CometStructVector;
import org.apache.comet.vector.CometVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarMap;

public class CometMapVector
extends CometDecodedVector {
    final MapVector mapVector;
    final ValueVector dataVector;
    final CometStructVector dataColumnVector;
    final DictionaryProvider dictionaryProvider;
    final ColumnVector keys;
    final ColumnVector values;

    public CometMapVector(ValueVector vector, boolean useDecimal128, DictionaryProvider dictionaryProvider) {
        super(vector, vector.getField(), useDecimal128);
        this.mapVector = (MapVector)vector;
        this.dataVector = this.mapVector.getDataVector();
        this.dictionaryProvider = dictionaryProvider;
        if (this.dataVector instanceof StructVector) {
            this.dataColumnVector = new CometStructVector(this.dataVector, useDecimal128, dictionaryProvider);
            if (this.dataColumnVector.children.size() != 2) {
                throw new RuntimeException("MapVector's dataVector should have 2 children, but got: " + this.dataColumnVector.children.size());
            }
        } else {
            throw new RuntimeException("MapVector's dataVector should be StructVector, but got: " + this.dataVector.getClass().getSimpleName());
        }
        this.keys = this.dataColumnVector.getChild(0);
        this.values = this.dataColumnVector.getChild(1);
    }

    @Override
    public ColumnarMap getMap(int i) {
        int start = this.mapVector.getOffsetBuffer().getInt(i * 4);
        int end = this.mapVector.getOffsetBuffer().getInt((i + 1) * 4);
        return new ColumnarMap(this.keys, this.values, start, end - start);
    }

    @Override
    public CometVector slice(int offset, int length) {
        TransferPair tp = this.valueVector.getTransferPair(this.valueVector.getAllocator());
        tp.splitAndTransfer(offset, length);
        return new CometMapVector(tp.getTo(), this.useDecimal128, this.dictionaryProvider);
    }
}

