/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.vector;

import org.apache.comet.shaded.arrow.vector.BaseVariableWidthVector;
import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.shaded.arrow.vector.types.pojo.Field;
import org.apache.comet.vector.CometVector;
import org.apache.spark.sql.comet.util.Utils;
import org.apache.spark.unsafe.Platform;

public abstract class CometDecodedVector
extends CometVector {
    protected final ValueVector valueVector;
    private boolean hasNull;
    private int numNulls;
    private int numValues;
    private int validityByteCacheIndex = -1;
    private byte validityByteCache;
    protected boolean isUuid;

    protected CometDecodedVector(ValueVector vector, Field valueField, boolean useDecimal128) {
        this(vector, valueField, useDecimal128, false);
    }

    protected CometDecodedVector(ValueVector vector, Field valueField, boolean useDecimal128, boolean isUuid) {
        super(Utils.fromArrowField(valueField), useDecimal128);
        this.valueVector = vector;
        this.numNulls = this.valueVector.getNullCount();
        this.numValues = this.valueVector.getValueCount();
        this.hasNull = this.numNulls != 0;
        this.isUuid = isUuid;
    }

    @Override
    public ValueVector getValueVector() {
        return this.valueVector;
    }

    @Override
    public void setNumNulls(int numNulls) {
        this.numNulls = numNulls;
        this.hasNull = numNulls != 0;
        this.validityByteCacheIndex = -1;
    }

    @Override
    public void setNumValues(int numValues) {
        this.numValues = numValues;
        if (this.valueVector instanceof BaseVariableWidthVector) {
            BaseVariableWidthVector bv = (BaseVariableWidthVector)this.valueVector;
            bv.setLastSet(numValues);
        }
        this.valueVector.setValueCount(numValues);
    }

    @Override
    public int numValues() {
        return this.numValues;
    }

    public boolean hasNull() {
        return this.hasNull;
    }

    public int numNulls() {
        return this.numNulls;
    }

    public boolean isNullAt(int rowId) {
        if (!this.hasNull) {
            return false;
        }
        int byteIndex = rowId >> 3;
        if (byteIndex != this.validityByteCacheIndex) {
            long validityBufferAddress = this.valueVector.getValidityBuffer().memoryAddress();
            this.validityByteCache = Platform.getByte(null, (long)(validityBufferAddress + (long)byteIndex));
            this.validityByteCacheIndex = byteIndex;
        }
        return (this.validityByteCache >> (rowId & 7) & 1) == 0;
    }
}

