/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.vector.complex.impl;

import java.time.LocalDateTime;
import org.apache.comet.shaded.arrow.vector.complex.impl.AbstractFieldReader;
import org.apache.comet.shaded.arrow.vector.complex.writer.TimeMilliWriter;
import org.apache.comet.shaded.arrow.vector.holders.NullableTimeMilliHolder;
import org.apache.comet.shaded.arrow.vector.holders.TimeMilliHolder;
import org.apache.comet.shaded.arrow.vector.types.Types;
import org.apache.comet.shaded.arrow.vector.util.DateUtility;

public class TimeMilliHolderReaderImpl
extends AbstractFieldReader {
    private TimeMilliHolder holder;

    public TimeMilliHolderReaderImpl(TimeMilliHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMEMILLI;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(TimeMilliHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableTimeMilliHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        return DateUtility.getLocalDateTimeFromEpochMilli(this.holder.value);
    }

    @Override
    public Object readObject() {
        return this.readLocalDateTime();
    }

    @Override
    public void copyAsValue(TimeMilliWriter writer) {
        writer.write(this.holder);
    }
}

