/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.crypto.AesCipher;
import org.apache.parquet.crypto.InternalColumnDecryptionSetup;
import org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.parquet.format.BlockCipher;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.SeekableInputStream;

public class DictionaryPageReader
implements DictionaryPageReadStore {
    private final Map<String, Optional<DictionaryPage>> cache;
    private final InternalFileDecryptor fileDecryptor;
    private final SeekableInputStream inputStream;
    private final ParquetReadOptions options;
    private final Map<String, ColumnChunkMetaData> columns = new HashMap<String, ColumnChunkMetaData>();

    DictionaryPageReader(BlockMetaData block, InternalFileDecryptor fileDecryptor, SeekableInputStream inputStream, ParquetReadOptions options) {
        this.cache = new ConcurrentHashMap<String, Optional<DictionaryPage>>();
        this.fileDecryptor = fileDecryptor;
        this.inputStream = inputStream;
        this.options = options;
        for (ColumnChunkMetaData column : block.getColumns()) {
            this.columns.put(column.getPath().toDotString(), column);
        }
    }

    public DictionaryPage readDictionaryPage(ColumnDescriptor descriptor) {
        String dotPath = String.join((CharSequence)".", descriptor.getPath());
        ColumnChunkMetaData column = this.columns.get(dotPath);
        if (column == null) {
            throw new ParquetDecodingException("Failed to load dictionary, unknown column: " + dotPath);
        }
        return this.cache.computeIfAbsent(dotPath, key -> {
            try {
                DictionaryPage dict = column.hasDictionaryPage() ? this.readDictionary(column) : null;
                return dict != null ? Optional.of(DictionaryPageReader.reusableCopy(dict)) : Optional.empty();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Failed to read dictionary", (Throwable)e);
            }
        }).orElse(null);
    }

    DictionaryPage readDictionary(ColumnChunkMetaData meta) throws IOException {
        PageHeader pageHeader;
        if (!meta.hasDictionaryPage()) {
            return null;
        }
        if (this.inputStream.getPos() != meta.getStartingPos()) {
            this.inputStream.seek(meta.getStartingPos());
        }
        boolean encryptedColumn = false;
        InternalColumnDecryptionSetup columnDecryptionSetup = null;
        byte[] dictionaryPageAAD = null;
        BlockCipher.Decryptor pageDecryptor = null;
        if (null != this.fileDecryptor && !this.fileDecryptor.plaintextFile() && (columnDecryptionSetup = this.fileDecryptor.getColumnSetup(meta.getPath())).isEncrypted()) {
            encryptedColumn = true;
        }
        if (!encryptedColumn) {
            pageHeader = Util.readPageHeader((InputStream)this.inputStream);
        } else {
            byte[] dictionaryPageHeaderAAD = AesCipher.createModuleAAD((byte[])this.fileDecryptor.getFileAAD(), (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.DictionaryPageHeader, (int)meta.getRowGroupOrdinal(), (int)columnDecryptionSetup.getOrdinal(), (int)-1);
            pageHeader = Util.readPageHeader((InputStream)this.inputStream, (BlockCipher.Decryptor)columnDecryptionSetup.getMetaDataDecryptor(), (byte[])dictionaryPageHeaderAAD);
            dictionaryPageAAD = AesCipher.createModuleAAD((byte[])this.fileDecryptor.getFileAAD(), (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.DictionaryPage, (int)meta.getRowGroupOrdinal(), (int)columnDecryptionSetup.getOrdinal(), (int)-1);
            pageDecryptor = columnDecryptionSetup.getDataDecryptor();
        }
        if (!pageHeader.isSetDictionary_page_header()) {
            return null;
        }
        DictionaryPage compressedPage = this.readCompressedDictionary(pageHeader, this.inputStream, pageDecryptor, dictionaryPageAAD);
        CompressionCodecFactory.BytesInputDecompressor decompressor = this.options.getCodecFactory().getDecompressor(meta.getCodec());
        return new DictionaryPage(decompressor.decompress(compressedPage.getBytes(), compressedPage.getUncompressedSize()), compressedPage.getDictionarySize(), compressedPage.getEncoding());
    }

    private DictionaryPage readCompressedDictionary(PageHeader pageHeader, SeekableInputStream fin, BlockCipher.Decryptor pageDecryptor, byte[] dictionaryPageAAD) throws IOException {
        DictionaryPageHeader dictHeader = pageHeader.getDictionary_page_header();
        int uncompressedPageSize = pageHeader.getUncompressed_page_size();
        int compressedPageSize = pageHeader.getCompressed_page_size();
        byte[] dictPageBytes = new byte[compressedPageSize];
        fin.readFully(dictPageBytes);
        BytesInput bin = BytesInput.from((byte[])dictPageBytes);
        if (null != pageDecryptor) {
            bin = BytesInput.from((byte[])pageDecryptor.decrypt(bin.toByteArray(), dictionaryPageAAD));
        }
        return new DictionaryPage(bin, uncompressedPageSize, dictHeader.getNum_values(), Encoding.valueOf((String)dictHeader.getEncoding().name()));
    }

    private static DictionaryPage reusableCopy(DictionaryPage dict) throws IOException {
        return new DictionaryPage(BytesInput.from((byte[])dict.getBytes().toByteArray()), dict.getDictionarySize(), dict.getEncoding());
    }
}

