/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.math.BigInteger;
import org.apache.comet.parquet.MetadataColumnReader;
import org.apache.comet.parquet.Native;
import org.apache.comet.parquet.TypeUtil;
import org.apache.comet.shims.ShimResolveDefaultColumns;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.unsafe.types.UTF8String;

public class ConstantColumnReader
extends MetadataColumnReader {
    private boolean isNull;
    private Object value;

    public ConstantColumnReader(StructField field, int batchSize, boolean useDecimal128) {
        this(field.dataType(), TypeUtil.convertToParquet(field), batchSize, useDecimal128);
        this.value = ShimResolveDefaultColumns.getExistenceDefaultValue(field);
        this.init(this.value);
    }

    public ConstantColumnReader(StructField field, int batchSize, InternalRow values, int index, boolean useDecimal128) {
        this(field.dataType(), TypeUtil.convertToParquet(field), batchSize, useDecimal128);
        this.init(values, index);
    }

    public ConstantColumnReader(DataType type, ColumnDescriptor descriptor, Object value, boolean useDecimal128) {
        super(type, descriptor, useDecimal128);
        this.value = value;
    }

    ConstantColumnReader(DataType type, ColumnDescriptor descriptor, int batchSize, boolean useDecimal128) {
        super(type, descriptor, useDecimal128);
        this.batchSize = batchSize;
        this.initNative();
    }

    @Override
    public void setBatchSize(int batchSize) {
        super.setBatchSize(batchSize);
        this.init(this.value);
    }

    @Override
    public void readBatch(int total) {
        super.readBatch(total);
        if (this.isNull) {
            this.setNumNulls(total);
        }
    }

    private void init(InternalRow values, int index) {
        Object value = values.get(index, this.type);
        this.init(value);
    }

    private void init(Object value) {
        if (value == null) {
            Native.setNull(this.nativeHandle);
            this.isNull = true;
        } else if (this.type == DataTypes.BooleanType) {
            Native.setBoolean(this.nativeHandle, (Boolean)value);
        } else if (this.type == DataTypes.ByteType) {
            Native.setByte(this.nativeHandle, (Byte)value);
        } else if (this.type == DataTypes.ShortType) {
            Native.setShort(this.nativeHandle, (Short)value);
        } else if (this.type == DataTypes.IntegerType) {
            Native.setInt(this.nativeHandle, (Integer)value);
        } else if (this.type == DataTypes.LongType) {
            Native.setLong(this.nativeHandle, (Long)value);
        } else if (this.type == DataTypes.FloatType) {
            Native.setFloat(this.nativeHandle, ((Float)value).floatValue());
        } else if (this.type == DataTypes.DoubleType) {
            Native.setDouble(this.nativeHandle, (Double)value);
        } else if (this.type == DataTypes.BinaryType) {
            Native.setBinary(this.nativeHandle, (byte[])value);
        } else if (this.type == DataTypes.StringType) {
            Native.setBinary(this.nativeHandle, ((UTF8String)value).getBytes());
        } else if (this.type == DataTypes.DateType) {
            Native.setInt(this.nativeHandle, (Integer)value);
        } else if (this.type == DataTypes.TimestampType || this.type == TimestampNTZType$.MODULE$) {
            Native.setLong(this.nativeHandle, (Long)value);
        } else if (this.type instanceof DecimalType) {
            DecimalType dt = (DecimalType)this.type;
            Decimal d = (Decimal)value;
            if (!this.useDecimal128 && dt.precision() <= Decimal.MAX_INT_DIGITS()) {
                Native.setInt(this.nativeHandle, (int)d.toUnscaledLong());
            } else if (!this.useDecimal128 && dt.precision() <= Decimal.MAX_LONG_DIGITS()) {
                Native.setLong(this.nativeHandle, d.toUnscaledLong());
            } else {
                BigInteger integer = d.toJavaBigDecimal().unscaledValue();
                byte[] bytes = integer.toByteArray();
                Native.setDecimal(this.nativeHandle, bytes);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported Spark type: " + this.type);
        }
    }
}

