/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.crypto.AesCipher;
import org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.parquet.format.BlockCipher;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.io.ParquetDecodingException;

public class ColumnPageReader
implements PageReader {
    private final CompressionCodecFactory.BytesInputDecompressor decompressor;
    private final long valueCount;
    private final Queue<DataPage> compressedPages;
    private final DictionaryPage compressedDictionaryPage;
    private final OffsetIndex offsetIndex;
    private final long rowCount;
    private int pageIndex = 0;
    private final BlockCipher.Decryptor blockDecryptor;
    private final byte[] dataPageAAD;
    private final byte[] dictionaryPageAAD;

    ColumnPageReader(CompressionCodecFactory.BytesInputDecompressor decompressor, List<DataPage> compressedPages, DictionaryPage compressedDictionaryPage, OffsetIndex offsetIndex, long rowCount, BlockCipher.Decryptor blockDecryptor, byte[] fileAAD, int rowGroupOrdinal, int columnOrdinal) {
        this.decompressor = decompressor;
        this.compressedPages = new ArrayDeque<DataPage>(compressedPages);
        this.compressedDictionaryPage = compressedDictionaryPage;
        long count = 0L;
        for (DataPage p : compressedPages) {
            count += (long)p.getValueCount();
        }
        this.valueCount = count;
        this.offsetIndex = offsetIndex;
        this.rowCount = rowCount;
        this.blockDecryptor = blockDecryptor;
        if (blockDecryptor != null) {
            this.dataPageAAD = AesCipher.createModuleAAD((byte[])fileAAD, (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.DataPage, (int)rowGroupOrdinal, (int)columnOrdinal, (int)0);
            this.dictionaryPageAAD = AesCipher.createModuleAAD((byte[])fileAAD, (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.DictionaryPage, (int)rowGroupOrdinal, (int)columnOrdinal, (int)-1);
        } else {
            this.dataPageAAD = null;
            this.dictionaryPageAAD = null;
        }
    }

    public long getTotalValueCount() {
        return this.valueCount;
    }

    public int getPageValueCount() {
        return this.compressedPages.element().getValueCount();
    }

    public void skipPage() {
        this.compressedPages.poll();
        ++this.pageIndex;
    }

    public DataPage readPage() {
        DataPage compressedPage = this.compressedPages.poll();
        if (compressedPage == null) {
            return null;
        }
        final int currentPageIndex = this.pageIndex++;
        if (null != this.blockDecryptor) {
            AesCipher.quickUpdatePageAAD((byte[])this.dataPageAAD, (int)this.getPageOrdinal(currentPageIndex));
        }
        return (DataPage)compressedPage.accept((DataPage.Visitor)new DataPage.Visitor<DataPage>(){

            public DataPage visit(DataPageV1 dataPageV1) {
                try {
                    DataPageV1 decompressedPage;
                    BytesInput bytes = dataPageV1.getBytes();
                    if (null != ColumnPageReader.this.blockDecryptor) {
                        bytes = BytesInput.from((byte[])ColumnPageReader.this.blockDecryptor.decrypt(bytes.toByteArray(), ColumnPageReader.this.dataPageAAD));
                    }
                    BytesInput decompressed = ColumnPageReader.this.decompressor.decompress(bytes, dataPageV1.getUncompressedSize());
                    if (ColumnPageReader.this.offsetIndex == null) {
                        decompressedPage = new DataPageV1(decompressed, dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), dataPageV1.getStatistics(), dataPageV1.getRlEncoding(), dataPageV1.getDlEncoding(), dataPageV1.getValueEncoding());
                    } else {
                        long firstRowIndex = ColumnPageReader.this.offsetIndex.getFirstRowIndex(currentPageIndex);
                        decompressedPage = new DataPageV1(decompressed, dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), firstRowIndex, Math.toIntExact(ColumnPageReader.this.offsetIndex.getLastRowIndex(currentPageIndex, ColumnPageReader.this.rowCount) - firstRowIndex + 1L), dataPageV1.getStatistics(), dataPageV1.getRlEncoding(), dataPageV1.getDlEncoding(), dataPageV1.getValueEncoding());
                    }
                    if (dataPageV1.getCrc().isPresent()) {
                        decompressedPage.setCrc(dataPageV1.getCrc().getAsInt());
                    }
                    return decompressedPage;
                }
                catch (IOException e) {
                    throw new ParquetDecodingException("could not decompress page", (Throwable)e);
                }
            }

            public DataPage visit(DataPageV2 dataPageV2) {
                if (!dataPageV2.isCompressed() && ColumnPageReader.this.offsetIndex == null && null == ColumnPageReader.this.blockDecryptor) {
                    return dataPageV2;
                }
                BytesInput pageBytes = dataPageV2.getData();
                if (null != ColumnPageReader.this.blockDecryptor) {
                    try {
                        pageBytes = BytesInput.from((byte[])ColumnPageReader.this.blockDecryptor.decrypt(pageBytes.toByteArray(), ColumnPageReader.this.dataPageAAD));
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("could not convert page ByteInput to byte array", (Throwable)e);
                    }
                }
                if (dataPageV2.isCompressed()) {
                    int uncompressedSize = Math.toIntExact((long)dataPageV2.getUncompressedSize() - dataPageV2.getDefinitionLevels().size() - dataPageV2.getRepetitionLevels().size());
                    try {
                        pageBytes = ColumnPageReader.this.decompressor.decompress(pageBytes, uncompressedSize);
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("could not decompress page", (Throwable)e);
                    }
                }
                if (ColumnPageReader.this.offsetIndex == null) {
                    return DataPageV2.uncompressed((int)dataPageV2.getRowCount(), (int)dataPageV2.getNullCount(), (int)dataPageV2.getValueCount(), (BytesInput)dataPageV2.getRepetitionLevels(), (BytesInput)dataPageV2.getDefinitionLevels(), (Encoding)dataPageV2.getDataEncoding(), (BytesInput)pageBytes, (Statistics)dataPageV2.getStatistics());
                }
                return DataPageV2.uncompressed((int)dataPageV2.getRowCount(), (int)dataPageV2.getNullCount(), (int)dataPageV2.getValueCount(), (long)ColumnPageReader.this.offsetIndex.getFirstRowIndex(currentPageIndex), (BytesInput)dataPageV2.getRepetitionLevels(), (BytesInput)dataPageV2.getDefinitionLevels(), (Encoding)dataPageV2.getDataEncoding(), (BytesInput)pageBytes, (Statistics)dataPageV2.getStatistics());
            }
        });
    }

    public DictionaryPage readDictionaryPage() {
        if (this.compressedDictionaryPage == null) {
            return null;
        }
        try {
            BytesInput bytes = this.compressedDictionaryPage.getBytes();
            if (null != this.blockDecryptor) {
                bytes = BytesInput.from((byte[])this.blockDecryptor.decrypt(bytes.toByteArray(), this.dictionaryPageAAD));
            }
            DictionaryPage decompressedPage = new DictionaryPage(this.decompressor.decompress(bytes, this.compressedDictionaryPage.getUncompressedSize()), this.compressedDictionaryPage.getDictionarySize(), this.compressedDictionaryPage.getEncoding());
            if (this.compressedDictionaryPage.getCrc().isPresent()) {
                decompressedPage.setCrc(this.compressedDictionaryPage.getCrc().getAsInt());
            }
            return decompressedPage;
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Could not decompress dictionary page", (Throwable)e);
        }
    }

    private int getPageOrdinal(int currentPageIndex) {
        return this.offsetIndex == null ? currentPageIndex : this.offsetIndex.getPageOrdinal(currentPageIndex);
    }
}

