/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.comet.CometConf;
import org.apache.comet.Constants;
import org.apache.spark.sql.comet.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NativeBase {
    static final String ARROW_UNSAFE_MEMORY_ACCESS = "arrow.enable_unsafe_memory_access";
    static final String ARROW_NULL_CHECK_FOR_GET = "arrow.enable_null_check_for_get";
    private static final Logger LOG = LoggerFactory.getLogger(NativeBase.class);
    private static final String NATIVE_LIB_NAME = "comet";
    private static final String libraryToLoad = System.mapLibraryName("comet");
    private static boolean loaded = false;
    private static final String searchPattern = "libcomet-";

    public static synchronized boolean isLoaded() {
        return loaded;
    }

    static synchronized void setLoaded(boolean b) {
        loaded = b;
    }

    static synchronized void load() {
        if (loaded) {
            return;
        }
        NativeBase.cleanupOldTempLibs();
        if (!NativeBase.checkArch()) {
            LOG.warn("Comet is disabled. JDK compiled for x86_64 is used in a Mac based on Apple Silicon. In order to use Comet, Please install a JDK version for ARM64 architecture");
            return;
        }
        try {
            System.loadLibrary(libraryToLoad);
            loaded = true;
        }
        catch (UnsatisfiedLinkError ex) {
            NativeBase.bundleLoadLibrary();
        }
        NativeBase.initWithLogConf();
        if (!((Boolean)CometConf.COMET_DEBUG_ENABLED().get()).booleanValue()) {
            NativeBase.setArrowProperties();
        }
    }

    private static void bundleLoadLibrary() {
        String resourceName = NativeBase.resourceName();
        InputStream is = NativeBase.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new UnsupportedOperationException("Unsupported OS/arch, cannot find " + resourceName + ". Please try building from source.");
        }
        File tempLib = null;
        File tempLibLock = null;
        try {
            tempLibLock = File.createTempFile(searchPattern, "." + NativeBase.os().libExtension + ".lck");
            tempLib = new File(tempLibLock.getAbsolutePath().replaceFirst(".lck$", ""));
            Files.copy(is, tempLib.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.load(tempLib.getAbsolutePath());
            loaded = true;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot unpack libcomet: " + e);
        }
        finally {
            if (!loaded) {
                if (tempLib != null && tempLib.exists() && !tempLib.delete()) {
                    LOG.error("Cannot unpack libcomet / cannot delete a temporary native library " + tempLib);
                }
                if (tempLibLock != null && tempLibLock.exists() && !tempLibLock.delete()) {
                    LOG.error("Cannot unpack libcomet / cannot delete a temporary lock file " + tempLibLock);
                }
            } else {
                tempLib.deleteOnExit();
                tempLibLock.deleteOnExit();
            }
        }
    }

    private static void initWithLogConf() {
        String logConfPath = System.getProperty(Constants.LOG_CONF_PATH(), Utils.getConfPath(Constants.LOG_CONF_NAME()));
        if (logConfPath == null) {
            LOG.info("Couldn't locate log file from either COMET_CONF_DIR or comet.log.file.path. Using default log configuration which emits to stdout");
            logConfPath = "";
        } else {
            LOG.info("Using {} for native library logging", (Object)logConfPath);
        }
        NativeBase.init(logConfPath);
    }

    private static void cleanupOldTempLibs() {
        String tempFolder = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        File dir = new File(tempFolder);
        File[] tempLibFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(NativeBase.searchPattern) && !name.endsWith(".lck");
            }
        });
        if (tempLibFiles != null) {
            for (File tempLibFile : tempLibFiles) {
                File lckFile = new File(tempLibFile.getAbsolutePath() + ".lck");
                if (lckFile.exists()) continue;
                try {
                    tempLibFile.delete();
                }
                catch (SecurityException e) {
                    LOG.error("Failed to delete old temp lib", (Throwable)e);
                }
            }
        }
    }

    private static void setArrowProperties() {
        NativeBase.setPropertyIfNull(ARROW_UNSAFE_MEMORY_ACCESS, "true");
        NativeBase.setPropertyIfNull(ARROW_NULL_CHECK_FOR_GET, "false");
    }

    private static void setPropertyIfNull(String key, String value) {
        if (System.getProperty(key) == null) {
            LOG.info("Setting system property {} to {}", (Object)key, (Object)value);
            System.setProperty(key, value);
        } else {
            LOG.info("Skip setting system property {} to {}, because it is already set to {}", new Object[]{key, value, System.getProperty(key)});
        }
    }

    private static String arch() {
        return System.getProperty("os.arch");
    }

    private static OS os() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Linux")) {
            return OS.LINUX;
        }
        if (osName.contains("Mac")) {
            return OS.MAC;
        }
        if (osName.contains("Windows")) {
            return OS.WINDOWS;
        }
        if (osName.contains("Solaris") || osName.contains("SunOS")) {
            return OS.SOLARIS;
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + osName);
    }

    private static boolean checkArch() {
        if (NativeBase.os() == OS.MAC) {
            try {
                String javaArch = NativeBase.arch();
                Process process = Runtime.getRuntime().exec("uname -a");
                if (process.waitFor() == 0) {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = in.readLine()) != null) {
                        if (!javaArch.equals("x86_64") || !line.contains("ARM64")) continue;
                        return false;
                    }
                }
            }
            catch (IOException | InterruptedException e) {
                LOG.warn("Error parsing host architecture", (Throwable)e);
            }
        }
        return true;
    }

    private static String resourceName() {
        OS os = NativeBase.os();
        String packagePrefix = NativeBase.class.getPackage().getName().replace('.', '/');
        return "/" + packagePrefix + "/" + os.name + "/" + NativeBase.arch() + "/" + libraryToLoad;
    }

    static native void init(String var0);

    static {
        if (!NativeBase.isLoaded()) {
            NativeBase.load();
        }
    }

    private static enum OS {
        WINDOWS("win32", "so"),
        LINUX("linux", "so"),
        MAC("darwin", "dylib"),
        SOLARIS("solaris", "so");

        public final String name;
        public final String libExtension;

        private OS(String name, String libExtension) {
            this.name = name;
            this.libExtension = libExtension;
        }
    }
}

