/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.comet.execution.shuffle;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.MapSizesByExecutorId;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.api.ShuffleExecutorComponents;
import org.apache.spark.shuffle.sort.BypassMergeSortShuffleHandle;
import org.apache.spark.shuffle.sort.SerializedShuffleHandle;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.shuffle.sort.SortShuffleManager$;
import org.apache.spark.shuffle.sort.SortShuffleWriter$;
import org.apache.spark.sql.comet.execution.shuffle.CometBlockStoreShuffleReader;
import org.apache.spark.sql.comet.execution.shuffle.CometBlockStoreShuffleReader$;
import org.apache.spark.sql.comet.execution.shuffle.CometBypassMergeSortShuffleHandle;
import org.apache.spark.sql.comet.execution.shuffle.CometBypassMergeSortShuffleWriter;
import org.apache.spark.sql.comet.execution.shuffle.CometSerializedShuffleHandle;
import org.apache.spark.sql.comet.execution.shuffle.CometShuffleDependency;
import org.apache.spark.sql.comet.execution.shuffle.CometShuffleManager$;
import org.apache.spark.sql.comet.execution.shuffle.CometUnsafeShuffleWriter;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.collection.OpenHashSet;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001\u0002\u000b\u0016\u0001\u0011B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0006w\u0001!\t\u0001\u0010\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0011\u0019A\u0005\u0001)A\u0005\u0005\"1\u0011\n\u0001Q\u0001\n)C\u0001\"\u0019\u0001\t\u0006\u0004%IA\u0019\u0005\bS\u0002\u0011\r\u0011\"\u0011k\u0011\u0019q\u0007\u0001)A\u0005W\")q\u000e\u0001C\u0001a\"9\u00111\u0004\u0001\u0005B\u0005u\u0001bBA,\u0001\u0011\u0005\u0013\u0011\f\u0005\b\u0003w\u0002A\u0011IA?\u0011\u001d\t9\t\u0001C!\u0003\u0013;q!!%\u0016\u0011\u0003\t\u0019J\u0002\u0004\u0015+!\u0005\u0011Q\u0013\u0005\u0007w=!\t!a&\t\u000f\u0005eu\u0002\"\u0003\u0002\u001c\"Q\u0011qT\b\t\u0006\u0004%\t!!)\t\u000f\u0005=v\u0002\"\u0001\u00022\n\u00192i\\7fiNCWO\u001a4mK6\u000bg.Y4fe*\u0011acF\u0001\bg\",hM\u001a7f\u0015\tA\u0012$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!dG\u0001\u0006G>lW\r\u001e\u0006\u00039u\t1a]9m\u0015\tqr$A\u0003ta\u0006\u00148N\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0015Z\u0003\u0007\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003Y9j\u0011!\f\u0006\u0003-uI!aL\u0017\u0003\u001dMCWO\u001a4mK6\u000bg.Y4feB\u0011\u0011\u0007N\u0007\u0002e)\u00111'H\u0001\tS:$XM\u001d8bY&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0011\u0005aJT\"A\u000f\n\u0005ij\"!C*qCJ\\7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0011Qh\u0010\t\u0003}\u0001i\u0011!\u0006\u0005\u0006m\t\u0001\raN\u0001\u0013g>\u0014Ho\u00155vM\u001adW-T1oC\u001e,'/F\u0001C!\t\u0019e)D\u0001E\u0015\t)U&\u0001\u0003t_J$\u0018BA$E\u0005I\u0019vN\u001d;TQV4g\r\\3NC:\fw-\u001a:\u0002'M|'\u000f^*ik\u001a4G.Z'b]\u0006<WM\u001d\u0011\u0002)Q\f7o[%e\u001b\u0006\u00048OR8s'\",hM\u001a7f!\u0011Y%\u000bV,\u000e\u00031S!!\u0014(\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002P!\u0006!Q\u000f^5m\u0015\u0005\t\u0016\u0001\u00026bm\u0006L!a\u0015'\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002'+&\u0011ak\n\u0002\u0004\u0013:$\bc\u0001-]=6\t\u0011L\u0003\u0002[7\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005=k\u0012BA/Z\u0005-y\u0005/\u001a8ICND7+\u001a;\u0011\u0005\u0019z\u0016B\u00011(\u0005\u0011auN\\4\u00023MDWO\u001a4mK\u0016CXmY;u_J\u001cu.\u001c9p]\u0016tGo]\u000b\u0002GB\u0011AmZ\u0007\u0002K*\u0011a-L\u0001\u0004CBL\u0017B\u00015f\u0005e\u0019\u0006.\u001e4gY\u0016,\u00050Z2vi>\u00148i\\7q_:,g\u000e^:\u0002)MDWO\u001a4mK\ncwnY6SKN|GN^3s+\u0005Y\u0007C\u0001\u0017m\u0013\tiWFA\rJ]\u0012,\u0007p\u00155vM\u001adWM\u00117pG.\u0014Vm]8mm\u0016\u0014\u0018!F:ik\u001a4G.\u001a\"m_\u000e\\'+Z:pYZ,'\u000fI\u0001\u0010e\u0016<\u0017n\u001d;feNCWO\u001a4mKV1\u0011O`A\t\u0003/!2A];x!\ta3/\u0003\u0002u[\ti1\u000b[;gM2,\u0007*\u00198eY\u0016DQA^\u0005A\u0002Q\u000b\u0011b\u001d5vM\u001adW-\u00133\t\u000baL\u0001\u0019A=\u0002\u0015\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010E\u00049ur\fy!!\u0006\n\u0005ml\"!E*ik\u001a4G.\u001a#fa\u0016tG-\u001a8dsB\u0011QP \u0007\u0001\t\u0019y\u0018B1\u0001\u0002\u0002\t\t1*\u0005\u0003\u0002\u0004\u0005%\u0001c\u0001\u0014\u0002\u0006%\u0019\u0011qA\u0014\u0003\u000f9{G\u000f[5oOB\u0019a%a\u0003\n\u0007\u00055qEA\u0002B]f\u00042!`A\t\t\u001d\t\u0019\"\u0003b\u0001\u0003\u0003\u0011\u0011A\u0016\t\u0004{\u0006]AaBA\r\u0013\t\u0007\u0011\u0011\u0001\u0002\u0002\u0007\u0006Iq-\u001a;SK\u0006$WM]\u000b\u0007\u0003?\tI#!\f\u0015!\u0005\u0005\u0012qFA\u001a\u0003o\tY$a\u0010\u0002D\u00055\u0003c\u0002\u0017\u0002$\u0005\u001d\u00121F\u0005\u0004\u0003Ki#!D*ik\u001a4G.\u001a*fC\u0012,'\u000fE\u0002~\u0003S!aa \u0006C\u0002\u0005\u0005\u0001cA?\u0002.\u00119\u0011\u0011\u0004\u0006C\u0002\u0005\u0005\u0001BBA\u0019\u0015\u0001\u0007!/\u0001\u0004iC:$G.\u001a\u0005\u0007\u0003kQ\u0001\u0019\u0001+\u0002\u001bM$\u0018M\u001d;NCBLe\u000eZ3y\u0011\u0019\tID\u0003a\u0001)\u0006YQM\u001c3NCBLe\u000eZ3y\u0011\u0019\tiD\u0003a\u0001)\u0006q1\u000f^1siB\u000b'\u000f^5uS>t\u0007BBA!\u0015\u0001\u0007A+\u0001\u0007f]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002F)\u0001\r!a\u0012\u0002\u000f\r|g\u000e^3yiB\u0019\u0001(!\u0013\n\u0007\u0005-SDA\u0006UCN\\7i\u001c8uKb$\bbBA(\u0015\u0001\u0007\u0011\u0011K\u0001\b[\u0016$(/[2t!\ra\u00131K\u0005\u0004\u0003+j#AG*ik\u001a4G.\u001a*fC\u0012lU\r\u001e:jGN\u0014V\r]8si\u0016\u0014\u0018!C4fi^\u0013\u0018\u000e^3s+\u0019\tY&!\u001a\u0002jQQ\u0011QLA6\u0003[\n\t(a\u001d\u0011\u000f1\ny&a\u0019\u0002h%\u0019\u0011\u0011M\u0017\u0003\u001bMCWO\u001a4mK^\u0013\u0018\u000e^3s!\ri\u0018Q\r\u0003\u0007\u007f.\u0011\r!!\u0001\u0011\u0007u\fI\u0007B\u0004\u0002\u0014-\u0011\r!!\u0001\t\r\u0005E2\u00021\u0001s\u0011\u0019\tyg\u0003a\u0001=\u0006)Q.\u00199JI\"9\u0011QI\u0006A\u0002\u0005\u001d\u0003bBA(\u0017\u0001\u0007\u0011Q\u000f\t\u0004Y\u0005]\u0014bAA=[\tY2\u000b[;gM2,wK]5uK6+GO]5dgJ+\u0007o\u001c:uKJ\f\u0011#\u001e8sK\u001eL7\u000f^3s'\",hM\u001a7f)\u0011\ty(!\"\u0011\u0007\u0019\n\t)C\u0002\u0002\u0004\u001e\u0012qAQ8pY\u0016\fg\u000eC\u0003w\u0019\u0001\u0007A+\u0001\u0003ti>\u0004HCAAF!\r1\u0013QR\u0005\u0004\u0003\u001f;#\u0001B+oSR\f1cQ8nKR\u001c\u0006.\u001e4gY\u0016l\u0015M\\1hKJ\u0004\"AP\b\u0014\u0007=)\u0003\u0007\u0006\u0002\u0002\u0014\u0006iBn\\1e'\",hM\u001a7f\u000bb,7-\u001e;pe\u000e{W\u000e]8oK:$8\u000fF\u0002d\u0003;CQAN\tA\u0002]\nAdY8naJ,7o]5p]\u000e{G-Z2G_J\u001c\u0006.\u001e4gY&tw-\u0006\u0002\u0002$B!\u0011QUAV\u001b\t\t9KC\u0002\u0002*v\t!![8\n\t\u00055\u0016q\u0015\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000e\fQc\u001d5pk2$')\u001f9bgNlUM]4f'>\u0014H\u000f\u0006\u0004\u0002\u0000\u0005M\u0016Q\u0017\u0005\u0006mM\u0001\ra\u000e\u0005\b\u0003o\u001b\u0002\u0019AA]\u0003\r!W\r\u001d\u0019\t\u0003w\u000by,!2\u0002LBA\u0001H_A_\u0003\u0007\fI\rE\u0002~\u0003\u007f#A\"!1\u00026\u0006\u0005\t\u0011!B\u0001\u0003\u0003\u0011Aa\u0018\u00132aA\u0019Q0!2\u0005\u0019\u0005\u001d\u0017QWA\u0001\u0002\u0003\u0015\t!!\u0001\u0003\t}#\u0013'\r\t\u0004{\u0006-G\u0001DAg\u0003k\u000b\t\u0011!A\u0003\u0002\u0005\u0005!\u0001B0%cI\u0002")
public class CometShuffleManager
implements ShuffleManager,
Logging {
    private ShuffleExecutorComponents shuffleExecutorComponents;
    private final SparkConf conf;
    private final SortShuffleManager sortShuffleManager;
    private final ConcurrentHashMap<Object, OpenHashSet<Object>> taskIdMapsForShuffle;
    private final IndexShuffleBlockResolver shuffleBlockResolver;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static boolean shouldBypassMergeSort(SparkConf conf, ShuffleDependency<?, ?, ?> dep) {
        return CometShuffleManager$.MODULE$.shouldBypassMergeSort(conf, dep);
    }

    public static CompressionCodec compressionCodecForShuffling() {
        return CometShuffleManager$.MODULE$.compressionCodecForShuffling();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public final <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        return ShuffleManager.getReader$((ShuffleManager)this, (ShuffleHandle)handle, (int)startPartition, (int)endPartition, (TaskContext)context, (ShuffleReadMetricsReporter)metrics);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SortShuffleManager sortShuffleManager() {
        return this.sortShuffleManager;
    }

    private ShuffleExecutorComponents shuffleExecutorComponents$lzycompute() {
        CometShuffleManager cometShuffleManager = this;
        synchronized (cometShuffleManager) {
            if (!this.bitmap$0) {
                this.shuffleExecutorComponents = CometShuffleManager$.MODULE$.org$apache$spark$sql$comet$execution$shuffle$CometShuffleManager$$loadShuffleExecutorComponents(this.conf);
                this.bitmap$0 = true;
            }
        }
        return this.shuffleExecutorComponents;
    }

    private ShuffleExecutorComponents shuffleExecutorComponents() {
        if (!this.bitmap$0) {
            return this.shuffleExecutorComponents$lzycompute();
        }
        return this.shuffleExecutorComponents;
    }

    public IndexShuffleBlockResolver shuffleBlockResolver() {
        return this.shuffleBlockResolver;
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, ShuffleDependency<K, V, C> dependency) {
        if (dependency instanceof CometShuffleDependency) {
            if (CometShuffleManager$.MODULE$.shouldBypassMergeSort(this.conf, dependency) || !SortShuffleManager$.MODULE$.canUseSerializedShuffle(dependency)) {
                return new CometBypassMergeSortShuffleHandle<K, V>(shuffleId, dependency);
            }
            return new CometSerializedShuffleHandle<K, V>(shuffleId, dependency);
        }
        if (SortShuffleWriter$.MODULE$.shouldBypassMergeSort(this.conf, dependency)) {
            return new BypassMergeSortShuffleHandle(shuffleId, dependency);
        }
        if (SortShuffleManager$.MODULE$.canUseSerializedShuffle(dependency)) {
            return new SerializedShuffleHandle(shuffleId, dependency);
        }
        return new BaseShuffleHandle(shuffleId, dependency);
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        BaseShuffleHandle baseShuffleHandle = (BaseShuffleHandle)handle;
        if (baseShuffleHandle.dependency().shuffleMergeEnabled()) {
            MapSizesByExecutorId res = SparkEnv$.MODULE$.get().mapOutputTracker().getPushBasedShuffleMapSizesByExecutorId(handle.shuffleId(), startMapIndex, endMapIndex, startPartition, endPartition);
            tuple22 = new Tuple2((Object)res.iter(), (Object)BoxesRunTime.boxToBoolean((boolean)res.enableBatchFetch()));
        } else {
            Iterator address = SparkEnv$.MODULE$.get().mapOutputTracker().getMapSizesByExecutorId(handle.shuffleId(), startMapIndex, endMapIndex, startPartition, endPartition);
            tuple22 = tuple2 = new Tuple2((Object)address, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator blocksByAddress = (Iterator)tuple2._1();
        boolean canEnableBatchFetch = tuple2._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)blocksByAddress, (Object)BoxesRunTime.boxToBoolean((boolean)canEnableBatchFetch));
        Iterator blocksByAddress2 = (Iterator)tuple23._1();
        boolean canEnableBatchFetch2 = tuple23._2$mcZ$sp();
        if (handle instanceof CometBypassMergeSortShuffleHandle || handle instanceof CometSerializedShuffleHandle) {
            BaseShuffleHandle x$1 = (BaseShuffleHandle)handle;
            Iterator x$2 = blocksByAddress2;
            TaskContext x$3 = context;
            ShuffleReadMetricsReporter x$4 = metrics;
            boolean x$5 = canEnableBatchFetch2 && SortShuffleManager$.MODULE$.canUseBatchFetch(startPartition, endPartition, context);
            SerializerManager x$6 = CometBlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$5();
            BlockManager x$7 = CometBlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$6();
            MapOutputTracker x$8 = CometBlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$7();
            return new CometBlockStoreShuffleReader(x$1, (Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>>)x$2, x$3, x$4, x$6, x$7, x$8, x$5);
        }
        return this.sortShuffleManager().getReader(handle, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics);
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, long mapId, TaskContext context, ShuffleWriteMetricsReporter metrics) {
        OpenHashSet mapTaskIds;
        OpenHashSet openHashSet = mapTaskIds = this.taskIdMapsForShuffle.computeIfAbsent(BoxesRunTime.boxToInteger((int)handle.shuffleId()), x$2 -> CometShuffleManager.$anonfun$getWriter$1(BoxesRunTime.unboxToInt((Object)x$2)));
        synchronized (openHashSet) {
            mapTaskIds.add$mcJ$sp(context.taskAttemptId());
        }
        SparkEnv env = SparkEnv$.MODULE$.get();
        ShuffleHandle shuffleHandle = handle;
        if (shuffleHandle instanceof CometBypassMergeSortShuffleHandle) {
            CometBypassMergeSortShuffleHandle cometBypassMergeSortShuffleHandle = (CometBypassMergeSortShuffleHandle)shuffleHandle;
            return new CometBypassMergeSortShuffleWriter(env.blockManager(), context.taskMemoryManager(), context, cometBypassMergeSortShuffleHandle, mapId, env.conf(), metrics, this.shuffleExecutorComponents());
        }
        if (shuffleHandle instanceof CometSerializedShuffleHandle) {
            CometSerializedShuffleHandle cometSerializedShuffleHandle = (CometSerializedShuffleHandle)shuffleHandle;
            return new CometUnsafeShuffleWriter(env.blockManager(), context.taskMemoryManager(), cometSerializedShuffleHandle, mapId, context, env.conf(), metrics, this.shuffleExecutorComponents());
        }
        return this.sortShuffleManager().getWriter(handle, mapId, context, metrics);
    }

    public boolean unregisterShuffle(int shuffleId) {
        Option$.MODULE$.apply(this.taskIdMapsForShuffle.remove(BoxesRunTime.boxToInteger((int)shuffleId))).foreach((Function1 & Serializable)mapTaskIds -> {
            CometShuffleManager.$anonfun$unregisterShuffle$1(this, shuffleId, mapTaskIds);
            return BoxedUnit.UNIT;
        });
        return true;
    }

    public void stop() {
        this.shuffleBlockResolver().stop();
    }

    public static final /* synthetic */ boolean $anonfun$shuffleBlockResolver$1(Constructor c) {
        return ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))).contains((Object)BoxesRunTime.boxToInteger((int)c.getParameterCount()));
    }

    public static final /* synthetic */ OpenHashSet $anonfun$getWriter$1(int x$2) {
        return new OpenHashSet.mcJ.sp(16, (ClassTag)ClassTag$.MODULE$.Long());
    }

    public static final /* synthetic */ void $anonfun$unregisterShuffle$1(CometShuffleManager $this, int shuffleId$1, OpenHashSet mapTaskIds) {
        mapTaskIds.iterator().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)mapTaskId -> $this.shuffleBlockResolver().removeDataByMap(shuffleId$1, mapTaskId));
    }

    public CometShuffleManager(SparkConf conf) {
        this.conf = conf;
        ShuffleManager.$init$((ShuffleManager)this);
        Logging.$init$((Logging)this);
        if (!conf.getBoolean("spark.shuffle.spill", true)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "spark.shuffle.spill was set to false, but this configuration is ignored as of Spark 1.6+. Shuffle will continue to spill to disk when necessary.");
        }
        this.sortShuffleManager = new SortShuffleManager(conf);
        this.taskIdMapsForShuffle = new ConcurrentHashMap();
        this.shuffleBlockResolver = (IndexShuffleBlockResolver)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])IndexShuffleBlockResolver.class.getDeclaredConstructors()), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)CometShuffleManager.$anonfun$shuffleBlockResolver$1(c)))), (Function1 & Serializable)c -> {
            int n = c.getParameterCount();
            switch (n) {
                case 2: {
                    return (IndexShuffleBlockResolver)c.newInstance($this.conf, null);
                }
                case 3: {
                    return (IndexShuffleBlockResolver)c.newInstance($this.conf, null, Collections.emptyMap());
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }, ClassTag$.MODULE$.apply(IndexShuffleBlockResolver.class))));
    }
}

