/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.comet;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.CheckOverflow;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Remainder;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.comet.DecimalPrecision$DecimalExpression$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.math.package$;

public final class DecimalPrecision$ {
    public static final DecimalPrecision$ MODULE$ = new DecimalPrecision$();

    public Expression promote(boolean allowPrecisionLoss, Expression expr, boolean nullOnOverflow) {
        return (Expression)expr.transformUp((PartialFunction)new Serializable(allowPrecisionLoss, nullOnOverflow){
            private static final long serialVersionUID = 0L;
            private final boolean allowPrecisionLoss$1;
            private final boolean nullOnOverflow$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof BinaryArithmetic) {
                    BinaryArithmetic binaryArithmetic = (BinaryArithmetic)A1;
                    String string = ((Expression)binaryArithmetic.left()).prettyName();
                    String string2 = "promote_precision";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return (B1)binaryArithmetic;
                    }
                }
                if (A1 instanceof Add) {
                    Option<Tuple2<Object, Object>> option;
                    Add add = (Add)A1;
                    Expression expression = add.left();
                    Expression expression2 = add.right();
                    if (expression != null && !(option = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression)).isEmpty()) {
                        Option<Tuple2<Object, Object>> option2;
                        int p1 = ((Tuple2)option.get())._1$mcI$sp();
                        int s1 = ((Tuple2)option.get())._2$mcI$sp();
                        if (expression2 != null && !(option2 = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression2)).isEmpty()) {
                            int p2 = ((Tuple2)option2.get())._1$mcI$sp();
                            int s2 = ((Tuple2)option2.get())._2$mcI$sp();
                            int resultScale = package$.MODULE$.max(s1, s2);
                            DecimalType resultType = this.allowPrecisionLoss$1 ? DecimalType$.MODULE$.adjustPrecisionScale(package$.MODULE$.max(p1 - s1, p2 - s2) + resultScale + 1, resultScale) : DecimalType$.MODULE$.bounded(package$.MODULE$.max(p1 - s1, p2 - s2) + resultScale + 1, resultScale);
                            return (B1)new CheckOverflow((Expression)add, resultType, this.nullOnOverflow$1);
                        }
                    }
                }
                if (A1 instanceof Subtract) {
                    Option<Tuple2<Object, Object>> option;
                    Subtract subtract = (Subtract)A1;
                    Expression expression = subtract.left();
                    Expression expression3 = subtract.right();
                    if (expression != null && !(option = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression)).isEmpty()) {
                        Option<Tuple2<Object, Object>> option3;
                        int p1 = ((Tuple2)option.get())._1$mcI$sp();
                        int s1 = ((Tuple2)option.get())._2$mcI$sp();
                        if (expression3 != null && !(option3 = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression3)).isEmpty()) {
                            int p2 = ((Tuple2)option3.get())._1$mcI$sp();
                            int s2 = ((Tuple2)option3.get())._2$mcI$sp();
                            int resultScale = package$.MODULE$.max(s1, s2);
                            DecimalType resultType = this.allowPrecisionLoss$1 ? DecimalType$.MODULE$.adjustPrecisionScale(package$.MODULE$.max(p1 - s1, p2 - s2) + resultScale + 1, resultScale) : DecimalType$.MODULE$.bounded(package$.MODULE$.max(p1 - s1, p2 - s2) + resultScale + 1, resultScale);
                            return (B1)new CheckOverflow((Expression)subtract, resultType, this.nullOnOverflow$1);
                        }
                    }
                }
                if (A1 instanceof Multiply) {
                    Option<Tuple2<Object, Object>> option;
                    Multiply multiply = (Multiply)A1;
                    Expression expression = multiply.left();
                    Expression expression4 = multiply.right();
                    if (expression != null && !(option = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression)).isEmpty()) {
                        Option<Tuple2<Object, Object>> option4;
                        int p1 = ((Tuple2)option.get())._1$mcI$sp();
                        int s1 = ((Tuple2)option.get())._2$mcI$sp();
                        if (expression4 != null && !(option4 = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression4)).isEmpty()) {
                            int p2 = ((Tuple2)option4.get())._1$mcI$sp();
                            int s2 = ((Tuple2)option4.get())._2$mcI$sp();
                            DecimalType resultType = this.allowPrecisionLoss$1 ? DecimalType$.MODULE$.adjustPrecisionScale(p1 + p2 + 1, s1 + s2) : DecimalType$.MODULE$.bounded(p1 + p2 + 1, s1 + s2);
                            return (B1)new CheckOverflow((Expression)multiply, resultType, this.nullOnOverflow$1);
                        }
                    }
                }
                if (A1 instanceof Divide) {
                    Option<Tuple2<Object, Object>> option;
                    Divide divide = (Divide)A1;
                    Expression expression = divide.left();
                    Expression expression5 = divide.right();
                    if (expression != null && !(option = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression)).isEmpty()) {
                        Option<Tuple2<Object, Object>> option5;
                        int p1 = ((Tuple2)option.get())._1$mcI$sp();
                        int s1 = ((Tuple2)option.get())._2$mcI$sp();
                        if (expression5 != null && !(option5 = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression5)).isEmpty()) {
                            DecimalType decimalType;
                            int p2 = ((Tuple2)option5.get())._1$mcI$sp();
                            int s2 = ((Tuple2)option5.get())._2$mcI$sp();
                            if (this.allowPrecisionLoss$1) {
                                int intDig = p1 - s1 + s2;
                                int scale = package$.MODULE$.max(DecimalType$.MODULE$.MINIMUM_ADJUSTED_SCALE(), s1 + p2 + 1);
                                int prec = intDig + scale;
                                decimalType = DecimalType$.MODULE$.adjustPrecisionScale(prec, scale);
                            } else {
                                int decDig;
                                int intDig = package$.MODULE$.min(DecimalType$.MODULE$.MAX_SCALE(), p1 - s1 + s2);
                                int diff = intDig + (decDig = package$.MODULE$.min(DecimalType$.MODULE$.MAX_SCALE(), package$.MODULE$.max(6, s1 + p2 + 1))) - DecimalType$.MODULE$.MAX_SCALE();
                                if (diff > 0) {
                                    intDig = DecimalType$.MODULE$.MAX_SCALE() - (decDig -= diff / 2 + 1);
                                }
                                decimalType = DecimalType$.MODULE$.bounded(intDig + decDig, decDig);
                            }
                            DecimalType resultType = decimalType;
                            return (B1)new CheckOverflow((Expression)divide, resultType, this.nullOnOverflow$1);
                        }
                    }
                }
                if (A1 instanceof Remainder) {
                    Option<Tuple2<Object, Object>> option;
                    Remainder remainder = (Remainder)A1;
                    Expression expression = remainder.left();
                    Expression expression6 = remainder.right();
                    if (expression != null && !(option = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression)).isEmpty()) {
                        Option<Tuple2<Object, Object>> option6;
                        int p1 = ((Tuple2)option.get())._1$mcI$sp();
                        int s1 = ((Tuple2)option.get())._2$mcI$sp();
                        if (expression6 != null && !(option6 = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression6)).isEmpty()) {
                            int p2 = ((Tuple2)option6.get())._1$mcI$sp();
                            int s2 = ((Tuple2)option6.get())._2$mcI$sp();
                            DecimalType resultType = this.allowPrecisionLoss$1 ? DecimalType$.MODULE$.adjustPrecisionScale(package$.MODULE$.min(p1 - s1, p2 - s2) + package$.MODULE$.max(s1, s2), package$.MODULE$.max(s1, s2)) : DecimalType$.MODULE$.bounded(package$.MODULE$.min(p1 - s1, p2 - s2) + package$.MODULE$.max(s1, s2), package$.MODULE$.max(s1, s2));
                            return (B1)new CheckOverflow((Expression)remainder, resultType, this.nullOnOverflow$1);
                        }
                    }
                }
                return (B1)A1;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                if (expression instanceof BinaryArithmetic) {
                    BinaryArithmetic binaryArithmetic = (BinaryArithmetic)expression;
                    String string = ((Expression)binaryArithmetic.left()).prettyName();
                    String string2 = "promote_precision";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return true;
                    }
                }
                if (expression instanceof Add) {
                    Option<Tuple2<Object, Object>> option;
                    Option<Tuple2<Object, Object>> option2;
                    Add add = (Add)expression;
                    Expression expression2 = add.left();
                    Expression expression3 = add.right();
                    if (expression2 != null && !(option2 = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression2)).isEmpty() && expression3 != null && !(option = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression3)).isEmpty()) {
                        return true;
                    }
                }
                if (expression instanceof Subtract) {
                    Option<Tuple2<Object, Object>> option;
                    Option<Tuple2<Object, Object>> option3;
                    Subtract subtract = (Subtract)expression;
                    Expression expression4 = subtract.left();
                    Expression expression5 = subtract.right();
                    if (expression4 != null && !(option3 = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression4)).isEmpty() && expression5 != null && !(option = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression5)).isEmpty()) {
                        return true;
                    }
                }
                if (expression instanceof Multiply) {
                    Option<Tuple2<Object, Object>> option;
                    Option<Tuple2<Object, Object>> option4;
                    Multiply multiply = (Multiply)expression;
                    Expression expression6 = multiply.left();
                    Expression expression7 = multiply.right();
                    if (expression6 != null && !(option4 = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression6)).isEmpty() && expression7 != null && !(option = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression7)).isEmpty()) {
                        return true;
                    }
                }
                if (expression instanceof Divide) {
                    Option<Tuple2<Object, Object>> option;
                    Option<Tuple2<Object, Object>> option5;
                    Divide divide = (Divide)expression;
                    Expression expression8 = divide.left();
                    Expression expression9 = divide.right();
                    if (expression8 != null && !(option5 = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression8)).isEmpty() && expression9 != null && !(option = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression9)).isEmpty()) {
                        return true;
                    }
                }
                if (expression instanceof Remainder) {
                    Option<Tuple2<Object, Object>> option;
                    Option<Tuple2<Object, Object>> option6;
                    Remainder remainder = (Remainder)expression;
                    Expression expression10 = remainder.left();
                    Expression expression11 = remainder.right();
                    if (expression10 != null && !(option6 = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression10)).isEmpty() && expression11 != null && !(option = DecimalPrecision$DecimalExpression$.MODULE$.unapply(expression11)).isEmpty()) {
                        return true;
                    }
                }
                return true;
            }
            {
                this.allowPrecisionLoss$1 = allowPrecisionLoss$1;
                this.nullOnOverflow$1 = nullOnOverflow$1;
            }
        });
    }

    private DecimalPrecision$() {
    }
}

