/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.comet;

import java.io.Serializable;
import org.apache.comet.serde.ExprOuterClass;
import org.apache.comet.serde.OperatorOuterClass;
import org.apache.comet.serde.QueryPlanSerde$;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.comet.CometExec$;
import org.apache.spark.sql.comet.EmptyRDDWithPartitions;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class CometExecUtils$ {
    public static final CometExecUtils$ MODULE$ = new CometExecUtils$();

    public <T> RDD<T> emptyRDDWithPartitions(SparkContext sparkContext, int numPartitions, ClassTag<T> evidence$1) {
        return new EmptyRDDWithPartitions<T>(sparkContext, numPartitions, evidence$1);
    }

    public RDD<ColumnarBatch> getNativeLimitRDD(RDD<ColumnarBatch> childPlan, Seq<Attribute> outputAttribute, int limit) {
        return childPlan.mapPartitionsInternal((Function1 & Serializable)iter -> {
            OperatorOuterClass.Operator limitOp = (OperatorOuterClass.Operator)MODULE$.getLimitNativePlan(outputAttribute, limit).get();
            return CometExec$.MODULE$.getCometIterator((Seq<Iterator<ColumnarBatch>>)new .colon.colon(iter, (List)Nil$.MODULE$), outputAttribute.length(), limitOp);
        }, childPlan.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(ColumnarBatch.class));
    }

    public Option<OperatorOuterClass.Operator> getProjectionNativePlan(Seq<NamedExpression> projectList, Seq<Attribute> outputAttributes, Seq<SortOrder> sortOrder, SparkPlan child, int limit) {
        return this.getTopKNativePlan(outputAttributes, sortOrder, child, limit).flatMap((Function1 & Serializable)topK -> {
            Seq exprs = (Seq)projectList.map((Function1 & Serializable)x$1 -> QueryPlanSerde$.MODULE$.exprToProto((Expression)x$1, (Seq<Attribute>)child.output(), QueryPlanSerde$.MODULE$.exprToProto$default$3()));
            if (exprs.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDefined()))) {
                OperatorOuterClass.Projection.Builder projectBuilder = OperatorOuterClass.Projection.newBuilder();
                projectBuilder.addAllProjectList((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)exprs.map((Function1 & Serializable)x$3 -> (ExprOuterClass.Expr)x$3.get())).asJava());
                OperatorOuterClass.Operator.Builder opBuilder = OperatorOuterClass.Operator.newBuilder().addChildren((OperatorOuterClass.Operator)topK);
                return new Some((Object)opBuilder.setProjection(projectBuilder).build());
            }
            return None$.MODULE$;
        });
    }

    public Option<OperatorOuterClass.Operator> getLimitNativePlan(Seq<Attribute> outputAttributes, int limit) {
        OperatorOuterClass.Scan.Builder scanBuilder = OperatorOuterClass.Scan.newBuilder();
        OperatorOuterClass.Operator.Builder scanOpBuilder = OperatorOuterClass.Operator.newBuilder();
        Seq scanTypes = (Seq)outputAttributes.flatten((Function1 & Serializable)attr -> QueryPlanSerde$.MODULE$.serializeDataType(attr.dataType()));
        if (scanTypes.length() == outputAttributes.length()) {
            scanBuilder.addAllFields((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)scanTypes).asJava());
            OperatorOuterClass.Limit.Builder limitBuilder = OperatorOuterClass.Limit.newBuilder();
            limitBuilder.setLimit(limit);
            OperatorOuterClass.Operator.Builder limitOpBuilder = OperatorOuterClass.Operator.newBuilder().addChildren(scanOpBuilder.setScan(scanBuilder));
            return new Some((Object)limitOpBuilder.setLimit(limitBuilder).build());
        }
        return None$.MODULE$;
    }

    public Option<OperatorOuterClass.Operator> getTopKNativePlan(Seq<Attribute> outputAttributes, Seq<SortOrder> sortOrder, SparkPlan child, int limit) {
        OperatorOuterClass.Scan.Builder scanBuilder = OperatorOuterClass.Scan.newBuilder();
        OperatorOuterClass.Operator.Builder scanOpBuilder = OperatorOuterClass.Operator.newBuilder();
        Seq scanTypes = (Seq)outputAttributes.flatten((Function1 & Serializable)attr -> QueryPlanSerde$.MODULE$.serializeDataType(attr.dataType()));
        if (scanTypes.length() == outputAttributes.length()) {
            scanBuilder.addAllFields((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)scanTypes).asJava());
            Seq sortOrders = (Seq)sortOrder.map((Function1 & Serializable)x$4 -> QueryPlanSerde$.MODULE$.exprToProto((Expression)x$4, (Seq<Attribute>)child.output(), QueryPlanSerde$.MODULE$.exprToProto$default$3()));
            if (sortOrders.forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDefined()))) {
                OperatorOuterClass.Sort.Builder sortBuilder = OperatorOuterClass.Sort.newBuilder();
                sortBuilder.addAllSortOrders((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)sortOrders.map((Function1 & Serializable)x$6 -> (ExprOuterClass.Expr)x$6.get())).asJava());
                sortBuilder.setFetch(limit);
                OperatorOuterClass.Operator.Builder sortOpBuilder = OperatorOuterClass.Operator.newBuilder().addChildren(scanOpBuilder.setScan(scanBuilder));
                return new Some((Object)sortOpBuilder.setSort(sortBuilder).build());
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private CometExecUtils$() {
    }
}

