/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.comet;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.comet.CometExecIterator;
import org.apache.comet.serde.OperatorOuterClass;
import org.apache.spark.SparkEnv$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.comet.CometMetricNode;
import org.apache.spark.sql.comet.CometMetricNode$;
import org.apache.spark.sql.comet.CometPlan;
import org.apache.spark.sql.comet.execution.shuffle.ArrowReaderIterator;
import org.apache.spark.sql.comet.util.Utils$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;

public final class CometExec$
implements Serializable {
    public static final CometExec$ MODULE$ = new CometExec$();
    private static final AtomicLong curId = new AtomicLong();

    private AtomicLong curId() {
        return curId;
    }

    public long newIterId() {
        return this.curId().getAndIncrement();
    }

    public CometExecIterator getCometIterator(Seq<Iterator<ColumnarBatch>> inputs, int numOutputCols, OperatorOuterClass.Operator nativePlan) {
        return this.getCometIterator(inputs, numOutputCols, nativePlan, CometMetricNode$.MODULE$.apply((Map<String, SQLMetric>)Predef$.MODULE$.Map().empty()));
    }

    public CometExecIterator getCometIterator(Seq<Iterator<ColumnarBatch>> inputs, int numOutputCols, OperatorOuterClass.Operator nativePlan, CometMetricNode nativeMetrics) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        nativePlan.writeTo(outputStream);
        outputStream.close();
        byte[] bytes = outputStream.toByteArray();
        return new CometExecIterator(this.newIterId(), inputs, numOutputCols, bytes, nativeMetrics);
    }

    public RDD<Tuple2<Object, ChunkedByteBuffer>> getByteArrayRdd(CometPlan cometPlan) {
        RDD qual$1 = ((SparkPlan)cometPlan).executeColumnar();
        Function1 & Serializable x$1 = (Function1 & Serializable)iter -> Utils$.MODULE$.serializeBatches((Iterator<ColumnarBatch>)iter);
        boolean x$2 = qual$1.mapPartitionsInternal$default$2();
        return qual$1.mapPartitionsInternal((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Iterator<ColumnarBatch> decodeBatches(ChunkedByteBuffer bytes, String source) {
        if (bytes.size() == 0L) {
            return package$.MODULE$.Iterator().empty();
        }
        CompressionCodec codec = CompressionCodec$.MODULE$.createCodec(SparkEnv$.MODULE$.get().conf());
        InputStream cbbis = bytes.toInputStream(bytes.toInputStream$default$1());
        DataInputStream ins = new DataInputStream(codec.compressedInputStream(cbbis));
        return new ArrowReaderIterator(Channels.newChannel(ins), source);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CometExec$.class);
    }

    private CometExec$() {
    }
}

