/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.vector;

import org.apache.comet.shaded.arrow.memory.BufferAllocator;
import org.apache.comet.shaded.arrow.vector.BitVectorHelper;
import org.apache.comet.shaded.arrow.vector.NullCheckingForGet;
import org.apache.comet.shaded.arrow.vector.TimeStampVector;
import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.shaded.arrow.vector.complex.impl.TimeStampMicroTZReaderImpl;
import org.apache.comet.shaded.arrow.vector.complex.reader.FieldReader;
import org.apache.comet.shaded.arrow.vector.holders.NullableTimeStampMicroTZHolder;
import org.apache.comet.shaded.arrow.vector.holders.TimeStampMicroTZHolder;
import org.apache.comet.shaded.arrow.vector.types.TimeUnit;
import org.apache.comet.shaded.arrow.vector.types.Types;
import org.apache.comet.shaded.arrow.vector.types.pojo.ArrowType;
import org.apache.comet.shaded.arrow.vector.types.pojo.Field;
import org.apache.comet.shaded.arrow.vector.types.pojo.FieldType;
import org.apache.comet.shaded.arrow.vector.util.TransferPair;

public final class TimeStampMicroTZVector
extends TimeStampVector {
    private final String timeZone;

    public TimeStampMicroTZVector(String name, BufferAllocator allocator, String timeZone) {
        this(name, FieldType.nullable(new ArrowType.Timestamp(TimeUnit.MICROSECOND, timeZone)), allocator);
    }

    public TimeStampMicroTZVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, fieldType, allocator);
        ArrowType.Timestamp arrowType = (ArrowType.Timestamp)fieldType.getType();
        this.timeZone = arrowType.getTimezone();
    }

    public TimeStampMicroTZVector(Field field, BufferAllocator allocator) {
        super(field, allocator);
        ArrowType.Timestamp arrowType = (ArrowType.Timestamp)field.getFieldType().getType();
        this.timeZone = arrowType.getTimezone();
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new TimeStampMicroTZReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPMICROTZ;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void get(int index, NullableTimeStampMicroTZHolder holder) {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getLong((long)index * 8L);
        holder.timezone = this.timeZone;
    }

    @Override
    public Long getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getLong((long)index * 8L);
    }

    public void set(int index, NullableTimeStampMicroTZHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.timeZone.equals(holder.timezone)) {
            throw new IllegalArgumentException(String.format("holder.timezone: %s not equal to vector timezone: %s", holder.timezone, this.timeZone));
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, TimeStampMicroTZHolder holder) {
        if (!this.timeZone.equals(holder.timezone)) {
            throw new IllegalArgumentException(String.format("holder.timezone: %s not equal to vector timezone: %s", holder.timezone, this.timeZone));
        }
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, NullableTimeStampMicroTZHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TimeStampMicroTZHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        TimeStampMicroTZVector to = new TimeStampMicroTZVector(ref, this.field.getFieldType(), allocator);
        return new TimeStampVector.TransferImpl(to);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        TimeStampMicroTZVector to = new TimeStampMicroTZVector(field, allocator);
        return new TimeStampVector.TransferImpl(to);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TimeStampVector.TransferImpl((TimeStampMicroTZVector)to);
    }
}

