/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.parquet.column.values.bloomfilter.BlockSplitBloomFilter;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.crypto.AesCipher;
import org.apache.parquet.crypto.InternalColumnDecryptionSetup;
import org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.format.BlockCipher;
import org.apache.parquet.format.BloomFilterHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.SeekableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterReader
implements FilterPredicate.Visitor<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(BloomFilterReader.class);
    private static final boolean BLOCK_MIGHT_MATCH = false;
    private static final boolean BLOCK_CANNOT_MATCH = true;
    private final Map<ColumnPath, ColumnChunkMetaData> columns;
    private final Map<ColumnPath, BloomFilter> cache = new HashMap<ColumnPath, BloomFilter>();
    private final InternalFileDecryptor fileDecryptor;
    private final SeekableInputStream inputStream;

    BloomFilterReader(BlockMetaData block, InternalFileDecryptor fileDecryptor, SeekableInputStream inputStream) {
        this.columns = new HashMap<ColumnPath, ColumnChunkMetaData>();
        for (ColumnChunkMetaData column : block.getColumns()) {
            this.columns.put(column.getPath(), column);
        }
        this.fileDecryptor = fileDecryptor;
        this.inputStream = inputStream;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.Eq<T> eq2) {
        Comparable value = eq2.getValue();
        if (value == null) {
            return false;
        }
        Operators.Column filterColumn = eq2.getColumn();
        ColumnChunkMetaData meta = this.columns.get(filterColumn.getColumnPath());
        if (meta == null) {
            return true;
        }
        try {
            BloomFilter bloomFilter = this.readBloomFilter(meta);
            if (bloomFilter != null && !bloomFilter.findHash(bloomFilter.hash((Object)value))) {
                return true;
            }
        }
        catch (RuntimeException e) {
            LOG.warn(e.getMessage());
            return false;
        }
        return false;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.NotEq<T> notEq) {
        return false;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.Lt<T> lt) {
        return false;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.LtEq<T> ltEq) {
        return false;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.Gt<T> gt) {
        return false;
    }

    public <T extends Comparable<T>> Boolean visit(Operators.GtEq<T> gtEq) {
        return false;
    }

    public Boolean visit(Operators.And and) {
        return (Boolean)and.getLeft().accept((FilterPredicate.Visitor)this) != false || (Boolean)and.getRight().accept((FilterPredicate.Visitor)this) != false;
    }

    public Boolean visit(Operators.Or or) {
        return (Boolean)or.getLeft().accept((FilterPredicate.Visitor)this) != false && (Boolean)or.getRight().accept((FilterPredicate.Visitor)this) != false;
    }

    public Boolean visit(Operators.Not not) {
        throw new IllegalArgumentException("This predicate " + not + " contains a not! Did you forget to run this predicate through LogicalInverseRewriter?");
    }

    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.UserDefined<T, U> udp) {
        return this.visit(udp, false);
    }

    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.LogicalNotUserDefined<T, U> udp) {
        return this.visit(udp.getUserDefined(), true);
    }

    private <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.UserDefined<T, U> ud, boolean inverted) {
        return false;
    }

    BloomFilter readBloomFilter(ColumnChunkMetaData meta) {
        if (this.cache.containsKey(meta.getPath())) {
            return this.cache.get(meta.getPath());
        }
        try {
            if (!this.cache.containsKey(meta.getPath())) {
                BloomFilter bloomFilter = this.readBloomFilterInternal(meta);
                if (bloomFilter == null) {
                    return null;
                }
                this.cache.put(meta.getPath(), bloomFilter);
            }
            return this.cache.get(meta.getPath());
        }
        catch (IOException e) {
            LOG.error("Failed to read Bloom filter data", (Throwable)e);
            return null;
        }
    }

    private BloomFilter readBloomFilterInternal(ColumnChunkMetaData meta) throws IOException {
        byte[] bitset;
        BloomFilterHeader bloomFilterHeader;
        InternalColumnDecryptionSetup columnDecryptionSetup;
        long bloomFilterOffset = meta.getBloomFilterOffset();
        if (bloomFilterOffset < 0L) {
            return null;
        }
        BlockCipher.Decryptor bloomFilterDecryptor = null;
        byte[] bloomFilterHeaderAAD = null;
        byte[] bloomFilterBitsetAAD = null;
        if (null != this.fileDecryptor && !this.fileDecryptor.plaintextFile() && (columnDecryptionSetup = this.fileDecryptor.getColumnSetup(meta.getPath())).isEncrypted()) {
            bloomFilterDecryptor = columnDecryptionSetup.getMetaDataDecryptor();
            bloomFilterHeaderAAD = AesCipher.createModuleAAD((byte[])this.fileDecryptor.getFileAAD(), (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.BloomFilterHeader, (int)meta.getRowGroupOrdinal(), (int)columnDecryptionSetup.getOrdinal(), (int)-1);
            bloomFilterBitsetAAD = AesCipher.createModuleAAD((byte[])this.fileDecryptor.getFileAAD(), (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.BloomFilterBitset, (int)meta.getRowGroupOrdinal(), (int)columnDecryptionSetup.getOrdinal(), (int)-1);
        }
        this.inputStream.seek(bloomFilterOffset);
        try {
            bloomFilterHeader = Util.readBloomFilterHeader((InputStream)this.inputStream, bloomFilterDecryptor, bloomFilterHeaderAAD);
        }
        catch (IOException e) {
            LOG.warn("read no bloom filter");
            return null;
        }
        int numBytes = bloomFilterHeader.getNumBytes();
        if (numBytes <= 0 || numBytes > 0x8000000) {
            LOG.warn("the read bloom filter size is wrong, size is {}", (Object)bloomFilterHeader.getNumBytes());
            return null;
        }
        if (!(bloomFilterHeader.getHash().isSetXXHASH() && bloomFilterHeader.getAlgorithm().isSetBLOCK() && bloomFilterHeader.getCompression().isSetUNCOMPRESSED())) {
            LOG.warn("the read bloom filter is not supported yet,  algorithm = {}, hash = {}, compression = {}", new Object[]{bloomFilterHeader.getAlgorithm(), bloomFilterHeader.getHash(), bloomFilterHeader.getCompression()});
            return null;
        }
        if (null == bloomFilterDecryptor) {
            bitset = new byte[numBytes];
            this.inputStream.readFully(bitset);
        } else {
            bitset = bloomFilterDecryptor.decrypt((InputStream)this.inputStream, bloomFilterBitsetAAD);
            if (bitset.length != numBytes) {
                throw new ParquetCryptoRuntimeException("Wrong length of decrypted bloom filter bitset");
            }
        }
        return new BlockSplitBloomFilter(bitset);
    }
}

