/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import org.apache.comet.CometConf$;
import org.apache.comet.expressions.CometCast$;
import org.apache.comet.expressions.CometEvalMode$;
import org.apache.comet.expressions.Compatible;
import org.apache.comet.expressions.Incompatible;
import org.apache.comet.expressions.SupportLevel;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.mutable.ListBuffer;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GenerateDocs$ {
    public static final GenerateDocs$ MODULE$ = new GenerateDocs$();

    public void main(String[] args) {
        this.generateConfigReference();
        this.generateCompatibilityGuide();
    }

    private void generateConfigReference() {
        String templateFilename = "docs/templates/configs-template.md";
        String outputFilename = "docs/source/user-guide/configs.md";
        BufferedOutputStream w = new BufferedOutputStream(new FileOutputStream(outputFilename));
        Source$.MODULE$.fromFile(templateFilename, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable)line -> {
            GenerateDocs$.$anonfun$generateConfigReference$1(w, line);
            return BoxedUnit.UNIT;
        });
        w.close();
    }

    private void generateCompatibilityGuide() {
        String templateFilename = "docs/templates/compatibility-template.md";
        String outputFilename = "docs/source/user-guide/compatibility.md";
        BufferedOutputStream w = new BufferedOutputStream(new FileOutputStream(outputFilename));
        Source$.MODULE$.fromFile(templateFilename, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable)line -> {
            GenerateDocs$.$anonfun$generateCompatibilityGuide$1(w, line);
            return BoxedUnit.UNIT;
        });
        w.close();
    }

    public static final /* synthetic */ void $anonfun$generateConfigReference$1(BufferedOutputStream w$1, String line) {
        String string = line.trim();
        String string2 = "<!--CONFIG_TABLE-->";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            ListBuffer publicConfigs = (ListBuffer)CometConf$.MODULE$.allConfs().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isPublic()));
            ListBuffer confs = (ListBuffer)publicConfigs.sortBy((Function1 & Serializable)x$2 -> x$2.key(), (Ordering)Ordering.String$.MODULE$);
            w$1.write("| Config | Description | Default Value |\n".getBytes());
            w$1.write("|--------|-------------|---------------|\n".getBytes());
            confs.foreach((Function1 & Serializable)conf -> {
                w$1.write(("| " + conf.key() + " | " + conf.doc().trim() + " | " + conf.defaultValueString() + " |\n").getBytes());
                return BoxedUnit.UNIT;
            });
            return;
        }
        w$1.write((line.trim() + "\n").getBytes());
    }

    public static final /* synthetic */ void $anonfun$generateCompatibilityGuide$3(DataType fromType$1, BufferedOutputStream w$2, DataType toType) {
        if (Cast$.MODULE$.canCast(fromType$1, toType)) {
            DataType dataType = fromType$1;
            DataType dataType2 = toType;
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                String fromTypeName = fromType$1.typeName().replace("(10,2)", "");
                String toTypeName = toType.typeName().replace("(10,2)", "");
                SupportLevel supportLevel = CometCast$.MODULE$.isSupported(fromType$1, toType, (Option<String>)None$.MODULE$, CometEvalMode$.MODULE$.LEGACY());
                if (supportLevel instanceof Compatible) {
                    Compatible compatible = (Compatible)supportLevel;
                    Option<String> notes = compatible.notes();
                    String notesStr = ((String)notes.getOrElse((Function0 & Serializable)() -> "")).trim();
                    w$2.write(("| " + fromTypeName + " | " + toTypeName + " | " + notesStr + " |\n").getBytes());
                    return;
                }
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$generateCompatibilityGuide$2(BufferedOutputStream w$2, DataType fromType) {
        CometCast$.MODULE$.supportedTypes().foreach((Function1 & Serializable)toType -> {
            GenerateDocs$.$anonfun$generateCompatibilityGuide$3(fromType, w$2, toType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$generateCompatibilityGuide$6(DataType fromType$2, BufferedOutputStream w$2, DataType toType) {
        if (Cast$.MODULE$.canCast(fromType$2, toType)) {
            DataType dataType = fromType$2;
            DataType dataType2 = toType;
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                String fromTypeName = fromType$2.typeName().replace("(10,2)", "");
                String toTypeName = toType.typeName().replace("(10,2)", "");
                SupportLevel supportLevel = CometCast$.MODULE$.isSupported(fromType$2, toType, (Option<String>)None$.MODULE$, CometEvalMode$.MODULE$.LEGACY());
                if (supportLevel instanceof Incompatible) {
                    Incompatible incompatible = (Incompatible)supportLevel;
                    Option<String> notes = incompatible.notes();
                    String notesStr = ((String)notes.getOrElse((Function0 & Serializable)() -> "")).trim();
                    w$2.write(("| " + fromTypeName + " | " + toTypeName + "  | " + notesStr + " |\n").getBytes());
                    return;
                }
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$generateCompatibilityGuide$5(BufferedOutputStream w$2, DataType fromType) {
        CometCast$.MODULE$.supportedTypes().foreach((Function1 & Serializable)toType -> {
            GenerateDocs$.$anonfun$generateCompatibilityGuide$6(fromType, w$2, toType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$generateCompatibilityGuide$1(BufferedOutputStream w$2, String line) {
        String string = line.trim();
        String string2 = "<!--COMPAT_CAST_TABLE-->";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            w$2.write("| From Type | To Type | Notes |\n".getBytes());
            w$2.write("|-|-|-|\n".getBytes());
            CometCast$.MODULE$.supportedTypes().foreach((Function1 & Serializable)fromType -> {
                GenerateDocs$.$anonfun$generateCompatibilityGuide$2(w$2, fromType);
                return BoxedUnit.UNIT;
            });
            return;
        }
        String string3 = line.trim();
        String string4 = "<!--INCOMPAT_CAST_TABLE-->";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            w$2.write("| From Type | To Type | Notes |\n".getBytes());
            w$2.write("|-|-|-|\n".getBytes());
            CometCast$.MODULE$.supportedTypes().foreach((Function1 & Serializable)fromType -> {
                GenerateDocs$.$anonfun$generateCompatibilityGuide$5(w$2, fromType);
                return BoxedUnit.UNIT;
            });
            return;
        }
        w$2.write((line.trim() + "\n").getBytes());
    }

    private GenerateDocs$() {
    }
}

