/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet;

import java.io.Serializable;
import java.nio.ByteOrder;
import org.apache.comet.CometConf$;
import org.apache.comet.CometExplainInfo$;
import org.apache.comet.CometRuntimeException;
import org.apache.comet.ConfigHelpers$;
import org.apache.comet.NativeBase;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.comet.CometBatchScanExec;
import org.apache.spark.sql.comet.CometScanExec;
import org.apache.spark.sql.comet.CometSparkToColumnarExec$;
import org.apache.spark.sql.comet.execution.shuffle.CometShuffleManager$;
import org.apache.spark.sql.comet.util.Utils$;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.LeafExecNode;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import org.apache.spark.sql.execution.datasources.v2.csv.CSVScan;
import org.apache.spark.sql.execution.datasources.v2.json.JsonScan;
import org.apache.spark.sql.execution.datasources.v2.parquet.ParquetScan;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class CometSparkSessionExtensions$
implements Logging {
    public static final CometSparkSessionExtensions$ MODULE$ = new CometSparkSessionExtensions$();
    private static boolean isBigEndian;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean isBigEndian$lzycompute() {
        CometSparkSessionExtensions$ cometSparkSessionExtensions$ = this;
        synchronized (cometSparkSessionExtensions$) {
            if (!bitmap$0) {
                isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
                bitmap$0 = true;
            }
        }
        return isBigEndian;
    }

    public boolean isBigEndian() {
        if (!bitmap$0) {
            return this.isBigEndian$lzycompute();
        }
        return isBigEndian;
    }

    public boolean isANSIEnabled(SQLConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)conf.getConf(SQLConf$.MODULE$.ANSI_ENABLED()));
    }

    public boolean isCometEnabled(SQLConf conf) {
        boolean bl;
        if (this.isBigEndian()) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Comet extension is disabled because platform is big-endian");
            return false;
        }
        if (!BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_ENABLED().get(conf))) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Comet extension is disabled, please turn on " + CometConf$.MODULE$.COMET_ENABLED().key() + " to enable it");
            return false;
        }
        if (BoxesRunTime.unboxToBoolean((Object)conf.getConf(SQLConf$.MODULE$.PARQUET_INT96_TIMESTAMP_CONVERSION()))) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Comet extension is disabled, because it currently doesn't support " + SQLConf$.MODULE$.PARQUET_INT96_TIMESTAMP_CONVERSION() + " setting to true.");
            return false;
        }
        try {
            bl = NativeBase.isLoaded();
        }
        catch (Throwable e) {
            if (BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_NATIVE_LOAD_REQUIRED().get(conf))) {
                throw new CometRuntimeException("Error when loading native library. Please fix the error and try again, or fallback to Spark by setting " + CometConf$.MODULE$.COMET_ENABLED().key() + " to false", e);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Comet extension is disabled because of error when loading native lib. Falling back to Spark", e);
            bl = false;
        }
        return bl;
    }

    public boolean isCometBroadCastForceEnabled(SQLConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_EXEC_BROADCAST_FORCE_ENABLED().get(conf));
    }

    public Option<String> getCometBroadcastNotEnabledReason(SQLConf conf) {
        if (!BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_EXEC_BROADCAST_EXCHANGE_ENABLED().get(conf)) && !this.isCometBroadCastForceEnabled(conf)) {
            return new Some((Object)(CometConf$.MODULE$.COMET_EXEC_BROADCAST_EXCHANGE_ENABLED().key() + ".enabled is not specified and " + CometConf$.MODULE$.COMET_EXEC_BROADCAST_FORCE_ENABLED().key() + " is not specified"));
        }
        if (!this.isSpark34Plus()) {
            return new Some((Object)"Native broadcast requires Spark 3.4 or newer");
        }
        return None$.MODULE$;
    }

    public boolean isOffHeapEnabled(SQLConf conf) {
        return conf.contains("spark.memory.offHeap.enabled") && StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.getConfString("spark.memory.offHeap.enabled")));
    }

    public boolean isTesting() {
        return System.getenv("SPARK_TESTING") != null || System.getProperty("spark.testing") != null;
    }

    public boolean isCometShuffleEnabled(SQLConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_EXEC_SHUFFLE_ENABLED().get(conf)) && this.isCometShuffleManagerEnabled(conf) && (this.isOffHeapEnabled(conf) || this.isTesting());
    }

    public Option<String> getCometShuffleNotEnabledReason(SQLConf conf) {
        if (!BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_EXEC_SHUFFLE_ENABLED().get(conf))) {
            return new Some((Object)(CometConf$.MODULE$.COMET_EXEC_SHUFFLE_ENABLED().key() + " is not enabled"));
        }
        if (!this.isCometShuffleManagerEnabled(conf)) {
            return new Some((Object)("spark.shuffle.manager is not set to " + CometShuffleManager$.MODULE$.getClass().getName()));
        }
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCometShuffleManagerEnabled(SQLConf conf) {
        if (!conf.contains("spark.shuffle.manager")) return false;
        String string = conf.getConfString("spark.shuffle.manager");
        String string2 = "org.apache.spark.sql.comet.execution.shuffle.CometShuffleManager";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public boolean isCometScanEnabled(SQLConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_NATIVE_SCAN_ENABLED().get(conf));
    }

    public boolean isCometExecEnabled(SQLConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_EXEC_ENABLED().get(conf));
    }

    public boolean isCometNativeShuffleMode(SQLConf conf) {
        String string = CometConf$.MODULE$.COMET_SHUFFLE_MODE().get(conf);
        switch (string == null ? 0 : string.hashCode()) {
            case -1052618729: {
                if (!"native".equals(string)) break;
                return true;
            }
            case 3005871: {
                if (!"auto".equals(string)) break;
                return true;
            }
        }
        return false;
    }

    public boolean isCometJVMShuffleMode(SQLConf conf) {
        String string = CometConf$.MODULE$.COMET_SHUFFLE_MODE().get(conf);
        switch (string == null ? 0 : string.hashCode()) {
            case 105633: {
                if (!"jvm".equals(string)) break;
                return true;
            }
            case 3005871: {
                if (!"auto".equals(string)) break;
                return true;
            }
        }
        return false;
    }

    public boolean isCometScan(SparkPlan op) {
        return op instanceof CometBatchScanExec || op instanceof CometScanExec;
    }

    public boolean org$apache$comet$CometSparkSessionExtensions$$shouldApplySparkToColumnar(SQLConf conf, SparkPlan op) {
        if (CometSparkToColumnarExec$.MODULE$.isSchemaSupported(op.schema())) {
            SparkPlan sparkPlan = op;
            if (sparkPlan instanceof FileSourceScanExec) {
                FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)sparkPlan;
                FileFormat fileFormat = fileSourceScanExec.relation().fileFormat();
                if (fileFormat instanceof CSVFileFormat) {
                    return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_CONVERT_FROM_CSV_ENABLED().get(conf));
                }
                if (fileFormat instanceof JsonFileFormat) {
                    return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_CONVERT_FROM_JSON_ENABLED().get(conf));
                }
                if (fileFormat instanceof ParquetFileFormat) {
                    return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_CONVERT_FROM_PARQUET_ENABLED().get(conf));
                }
                return this.isSparkToArrowEnabled(conf, op);
            }
            if (sparkPlan instanceof BatchScanExec) {
                BatchScanExec batchScanExec = (BatchScanExec)sparkPlan;
                Scan scan = batchScanExec.scan();
                if (scan instanceof CSVScan) {
                    return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_CONVERT_FROM_CSV_ENABLED().get(conf));
                }
                if (scan instanceof JsonScan) {
                    return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_CONVERT_FROM_JSON_ENABLED().get(conf));
                }
                if (scan instanceof ParquetScan) {
                    return BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_CONVERT_FROM_PARQUET_ENABLED().get(conf));
                }
                return this.isSparkToArrowEnabled(conf, op);
            }
            if (sparkPlan instanceof LeafExecNode) {
                return this.isSparkToArrowEnabled(conf, op);
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSparkToArrowEnabled(SQLConf conf, SparkPlan op) {
        if (!BoxesRunTime.unboxToBoolean((Object)CometConf$.MODULE$.COMET_SPARK_TO_ARROW_ENABLED().get(conf))) return false;
        String simpleClassName = Utils$.MODULE$.getSimpleName(op.getClass());
        String nodeName = simpleClassName.replaceAll("Exec$", "");
        if (!((SeqOps)CometConf$.MODULE$.COMET_SPARK_TO_ARROW_SUPPORTED_OPERATOR_LIST().get(conf)).contains((Object)nodeName)) return false;
        return true;
    }

    public boolean isSpark33Plus() {
        return StringOps$.MODULE$.$greater$eq$extension(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION()), "3.3");
    }

    public boolean isSpark34Plus() {
        return StringOps$.MODULE$.$greater$eq$extension(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION()), "3.4");
    }

    public boolean isSpark35Plus() {
        return StringOps$.MODULE$.$greater$eq$extension(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION()), "3.5");
    }

    public boolean isSpark40Plus() {
        return StringOps$.MODULE$.$greater$eq$extension(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION()), "4.0");
    }

    public long getCometMemoryOverheadInMiB(SparkConf sparkConf) {
        long executorMemoryMiB = ConfigHelpers$.MODULE$.byteFromString(sparkConf.get("spark.executor.memory", "1024MB"), ByteUnit.MiB);
        long minimum = ConfigHelpers$.MODULE$.byteFromString(sparkConf.get(CometConf$.MODULE$.COMET_MEMORY_OVERHEAD_MIN_MIB().key(), CometConf$.MODULE$.COMET_MEMORY_OVERHEAD_MIN_MIB().defaultValueString()), ByteUnit.MiB);
        double overheadFactor = sparkConf.getDouble(CometConf$.MODULE$.COMET_MEMORY_OVERHEAD_FACTOR().key(), BoxesRunTime.unboxToDouble((Object)CometConf$.MODULE$.COMET_MEMORY_OVERHEAD_FACTOR().defaultValue().get()));
        Option overHeadMemFromConf = sparkConf.getOption(CometConf$.MODULE$.COMET_MEMORY_OVERHEAD().key()).map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToLong((long)ConfigHelpers$.MODULE$.byteFromString(x$21, ByteUnit.MiB)));
        return BoxesRunTime.unboxToLong((Object)overHeadMemFromConf.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> package$.MODULE$.max((long)(overheadFactor * (double)executorMemoryMiB), minimum)));
    }

    public long getCometMemoryOverhead(SparkConf sparkConf) {
        return ByteUnit.MiB.toBytes(this.getCometMemoryOverheadInMiB(sparkConf));
    }

    public long getCometShuffleMemorySize(SparkConf sparkConf, SQLConf conf) {
        long cometMemoryOverhead = this.getCometMemoryOverheadInMiB(sparkConf);
        double overheadFactor = BoxesRunTime.unboxToDouble((Object)CometConf$.MODULE$.COMET_COLUMNAR_SHUFFLE_MEMORY_FACTOR().get(conf));
        Option<Object> cometShuffleMemoryFromConf = CometConf$.MODULE$.COMET_COLUMNAR_SHUFFLE_MEMORY_SIZE().get(conf);
        long shuffleMemorySize = BoxesRunTime.unboxToLong((Object)cometShuffleMemoryFromConf.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> (long)(overheadFactor * (double)cometMemoryOverhead)));
        if (shuffleMemorySize > cometMemoryOverhead) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Configured shuffle memory size " + shuffleMemorySize + " is larger than Comet memory overhead " + cometMemoryOverhead + ", using Comet memory overhead instead.");
            return ByteUnit.MiB.toBytes(cometMemoryOverhead);
        }
        return ByteUnit.MiB.toBytes(shuffleMemorySize);
    }

    public <T extends TreeNode<?>> T withInfo(T node, String info, Seq<T> exprs) {
        Set infoSet = info == null || info.isEmpty() ? Predef$.MODULE$.Set().empty() : Predef$.MODULE$.wrapRefArray((Object[])info.split("\n")).toSet();
        return this.withInfos(node, (Set<String>)infoSet, exprs);
    }

    public <T extends TreeNode<?>> T withInfos(T node, Set<String> info, Seq<T> exprs) {
        Option existingNodeInfos = node.getTagValue(CometExplainInfo$.MODULE$.EXTENSION_INFO());
        Set newNodeInfo = ((IterableOnceOps)((IterableOps)Option$.MODULE$.option2Iterable(existingNodeInfos).$plus$plus((IterableOnce)exprs.flatMap((Function1 & Serializable)x$22 -> x$22.getTagValue(CometExplainInfo$.MODULE$.EXTENSION_INFO())))).flatten(Predef$.MODULE$.$conforms())).toSet();
        node.setTagValue(CometExplainInfo$.MODULE$.EXTENSION_INFO(), (Object)newNodeInfo.$plus$plus(info));
        return node;
    }

    public <T extends TreeNode<?>> T withInfo(T node, Seq<T> exprs) {
        return this.withInfos(node, (Set<String>)Predef$.MODULE$.Set().empty(), exprs);
    }

    public Option<String> createMessage(boolean condition, Function0<String> message) {
        if (condition) {
            return new Some(message.apply());
        }
        return None$.MODULE$;
    }

    private CometSparkSessionExtensions$() {
    }
}

